/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.org.glassfish.gmbal.ManagedObjectManager;
import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.addressing.WSEPRExtension;
import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentFeature;
import com.sun.xml.internal.ws.api.ComponentRegistry;
import com.sun.xml.internal.ws.api.ComponentsFeature;
import com.sun.xml.internal.ws.api.EndpointAddress;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.client.WSPortInfo;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.Fiber;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptorFactory;
import com.sun.xml.internal.ws.api.pipe.SyncStartForAsyncFeature;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubelineAssembler;
import com.sun.xml.internal.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.AsyncResponseImpl;
import com.sun.xml.internal.ws.client.MonitorRootClient;
import com.sun.xml.internal.ws.client.RequestContext;
import com.sun.xml.internal.ws.client.ResponseContext;
import com.sun.xml.internal.ws.client.ResponseContextReceiver;
import com.sun.xml.internal.ws.client.SEIPortInfo;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.developer.WSBindingProvider;
import com.sun.xml.internal.ws.model.SOAPSEIModel;
import com.sun.xml.internal.ws.model.wsdl.WSDLDirectProperties;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortProperties;
import com.sun.xml.internal.ws.model.wsdl.WSDLProperties;
import com.sun.xml.internal.ws.resources.ClientMessages;
import com.sun.xml.internal.ws.util.Pool;
import com.sun.xml.internal.ws.util.RuntimeVersion;
import com.sun.xml.internal.ws.wsdl.OperationDispatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.RespectBindingFeature;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public abstract class Stub
implements WSBindingProvider,
ResponseContextReceiver,
ComponentRegistry {
    public static final String PREVENT_SYNC_START_FOR_ASYNC_INVOKE = "com.sun.xml.internal.ws.client.StubRequestSyncStartForAsyncInvoke";
    private Pool<Tube> tubes;
    private final Engine engine;
    protected final WSServiceDelegate owner;
    @Nullable
    protected WSEndpointReference endpointReference;
    protected final BindingImpl binding;
    protected final WSPortInfo portInfo;
    protected AddressingVersion addrVersion;
    public RequestContext requestContext = new RequestContext();
    private final RequestContext cleanRequestContext;
    private ResponseContext responseContext;
    @Nullable
    protected final WSDLPort wsdlPort;
    protected QName portname;
    @Nullable
    private volatile Header[] userOutboundHeaders;
    @NotNull
    private final WSDLProperties wsdlProperties;
    protected OperationDispatcher operationDispatcher = null;
    @NotNull
    private final ManagedObjectManager managedObjectManager;
    private boolean managedObjectManagerClosed = false;
    private final Set<Component> components = new CopyOnWriteArraySet<Component>();
    private static final Logger monitoringLogger = Logger.getLogger("com.sun.xml.internal.ws.monitoring");

    @Deprecated
    protected Stub(WSServiceDelegate wSServiceDelegate, Tube tube, BindingImpl bindingImpl, WSDLPort wSDLPort, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this(wSServiceDelegate, tube, null, null, bindingImpl, wSDLPort, endpointAddress, wSEndpointReference);
    }

    @Deprecated
    protected Stub(QName qName, WSServiceDelegate wSServiceDelegate, Tube tube, BindingImpl bindingImpl, WSDLPort wSDLPort, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this(wSServiceDelegate, tube, null, qName, bindingImpl, wSDLPort, endpointAddress, wSEndpointReference);
    }

    protected Stub(WSPortInfo wSPortInfo, BindingImpl bindingImpl, Tube tube, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this((WSServiceDelegate)wSPortInfo.getOwner(), tube, wSPortInfo, null, bindingImpl, wSPortInfo.getPort(), endpointAddress, wSEndpointReference);
    }

    protected Stub(WSPortInfo wSPortInfo, BindingImpl bindingImpl, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        this(wSPortInfo, bindingImpl, null, endpointAddress, wSEndpointReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stub(WSServiceDelegate wSServiceDelegate, @Nullable Tube tube, @Nullable WSPortInfo wSPortInfo, QName qName, BindingImpl bindingImpl, @Nullable WSDLPort wSDLPort, EndpointAddress endpointAddress, @Nullable WSEndpointReference wSEndpointReference) {
        Container container = ContainerResolver.getDefault().enterContainer(wSServiceDelegate.getContainer());
        try {
            ComponentsFeature componentsFeature;
            this.owner = wSServiceDelegate;
            this.portInfo = wSPortInfo;
            this.wsdlPort = wSDLPort != null ? wSDLPort : (wSPortInfo != null ? wSPortInfo.getPort() : null);
            this.portname = qName;
            if (qName == null) {
                if (wSPortInfo != null) {
                    this.portname = wSPortInfo.getPortName();
                } else if (wSDLPort != null) {
                    this.portname = wSDLPort.getName();
                }
            }
            this.binding = bindingImpl;
            ComponentFeature componentFeature = bindingImpl.getFeature(ComponentFeature.class);
            if (componentFeature != null && ComponentFeature.Target.STUB.equals((Object)componentFeature.getTarget())) {
                this.components.add(componentFeature.getComponent());
            }
            if ((componentsFeature = bindingImpl.getFeature(ComponentsFeature.class)) != null) {
                for (ComponentFeature componentFeature2 : componentsFeature.getComponentFeatures()) {
                    if (!ComponentFeature.Target.STUB.equals((Object)componentFeature2.getTarget())) continue;
                    this.components.add(componentFeature2.getComponent());
                }
            }
            if (wSEndpointReference != null) {
                this.requestContext.setEndPointAddressString(wSEndpointReference.getAddress());
            } else {
                this.requestContext.setEndpointAddress(endpointAddress);
            }
            this.engine = new Engine(this.getStringId(), wSServiceDelegate.getContainer(), wSServiceDelegate.getExecutor());
            this.endpointReference = wSEndpointReference;
            this.wsdlProperties = wSDLPort == null ? new WSDLDirectProperties(wSServiceDelegate.getServiceName(), qName) : new WSDLPortProperties(wSDLPort);
            this.cleanRequestContext = this.requestContext.copy();
            this.managedObjectManager = new MonitorRootClient(this).createManagedObjectManager(this);
            this.tubes = tube != null ? new Pool.TubePool(tube) : new Pool.TubePool(this.createPipeline(wSPortInfo, bindingImpl));
            this.addrVersion = bindingImpl.getAddressingVersion();
            this.managedObjectManager.resumeJMXRegistration();
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    private Tube createPipeline(WSPortInfo wSPortInfo, WSBinding wSBinding) {
        Object object;
        Stub.checkAllWSDLExtensionsUnderstood(wSPortInfo, wSBinding);
        SOAPSEIModel sOAPSEIModel = null;
        Class clazz = null;
        if (wSPortInfo instanceof SEIPortInfo) {
            object = (SEIPortInfo)wSPortInfo;
            sOAPSEIModel = ((SEIPortInfo)object).model;
            clazz = ((SEIPortInfo)object).sei;
        }
        object = wSPortInfo.getBindingId();
        TubelineAssembler tubelineAssembler = TubelineAssemblerFactory.create(Thread.currentThread().getContextClassLoader(), (BindingID)object, this.owner.getContainer());
        if (tubelineAssembler == null) {
            throw new WebServiceException("Unable to process bindingID=" + object);
        }
        return tubelineAssembler.createClient(new ClientTubeAssemblerContext(wSPortInfo.getEndpointAddress(), wSPortInfo.getPort(), this, wSBinding, this.owner.getContainer(), ((BindingImpl)wSBinding).createCodec(), (SEIModel)sOAPSEIModel, clazz));
    }

    public WSDLPort getWSDLPort() {
        return this.wsdlPort;
    }

    public WSService getService() {
        return this.owner;
    }

    public Pool<Tube> getTubes() {
        return this.tubes;
    }

    private static void checkAllWSDLExtensionsUnderstood(WSPortInfo wSPortInfo, WSBinding wSBinding) {
        if (wSPortInfo.getPort() != null && wSBinding.isFeatureEnabled(RespectBindingFeature.class)) {
            wSPortInfo.getPort().areRequiredExtensionsUnderstood();
        }
    }

    @Override
    public WSPortInfo getPortInfo() {
        return this.portInfo;
    }

    @Nullable
    public OperationDispatcher getOperationDispatcher() {
        if (this.operationDispatcher == null && this.wsdlPort != null) {
            this.operationDispatcher = new OperationDispatcher(this.wsdlPort, this.binding, null);
        }
        return this.operationDispatcher;
    }

    @NotNull
    protected abstract QName getPortName();

    @NotNull
    protected final QName getServiceName() {
        return this.owner.getServiceName();
    }

    public final Executor getExecutor() {
        return this.owner.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Packet process(Packet packet, RequestContext requestContext, ResponseContextReceiver responseContextReceiver) {
        Packet packet2;
        Packet packet3;
        packet.isSynchronousMEP = true;
        packet.component = this;
        this.configureRequestPacket(packet, requestContext);
        Pool<Tube> pool = this.tubes;
        if (pool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        this.configureFiber(fiber);
        Tube tube = pool.take();
        try {
            packet3 = fiber.runSync(tube, packet);
            packet2 = fiber.getPacket() == null ? packet : fiber.getPacket();
        }
        catch (Throwable throwable) {
            Packet packet4 = fiber.getPacket() == null ? packet : fiber.getPacket();
            responseContextReceiver.setResponseContext(new ResponseContext(packet4));
            pool.recycle(tube);
            throw throwable;
        }
        responseContextReceiver.setResponseContext(new ResponseContext(packet2));
        pool.recycle(tube);
        return packet3;
    }

    private void configureRequestPacket(Packet packet, RequestContext requestContext) {
        MessageHeaders messageHeaders;
        packet.proxy = this;
        packet.handlerConfig = this.binding.getHandlerConfig();
        Header[] headerArray = this.userOutboundHeaders;
        if (headerArray != null) {
            messageHeaders = packet.getMessage().getHeaders();
            for (Header header : headerArray) {
                messageHeaders.add(header);
            }
        }
        requestContext.fill(packet, this.binding.getAddressingVersion() != null);
        packet.addSatellite(this.wsdlProperties);
        if (this.addrVersion != null) {
            messageHeaders = packet.getMessage().getHeaders();
            AddressingUtils.fillRequestAddressingHeaders(messageHeaders, this.wsdlPort, this.binding, packet);
            if (this.endpointReference != null) {
                this.endpointReference.addReferenceParametersToList(packet.getMessage().getHeaders());
            }
        }
    }

    protected final void processAsync(AsyncResponseImpl<?> asyncResponseImpl, Packet packet, RequestContext requestContext, final Fiber.CompletionCallback completionCallback) {
        packet.component = this;
        this.configureRequestPacket(packet, requestContext);
        final Pool<Tube> pool = this.tubes;
        if (pool == null) {
            throw new WebServiceException("close method has already been invoked");
        }
        Fiber fiber = this.engine.createFiber();
        this.configureFiber(fiber);
        asyncResponseImpl.setCancelable(fiber);
        if (asyncResponseImpl.isCancelled()) {
            return;
        }
        FiberContextSwitchInterceptorFactory fiberContextSwitchInterceptorFactory = this.owner.getSPI(FiberContextSwitchInterceptorFactory.class);
        if (fiberContextSwitchInterceptorFactory != null) {
            fiber.addInterceptor(fiberContextSwitchInterceptorFactory.create());
        }
        final Tube tube = pool.take();
        Fiber.CompletionCallback completionCallback2 = new Fiber.CompletionCallback(){

            @Override
            public void onCompletion(@NotNull Packet packet) {
                pool.recycle(tube);
                completionCallback.onCompletion(packet);
            }

            @Override
            public void onCompletion(@NotNull Throwable throwable) {
                completionCallback.onCompletion(throwable);
            }
        };
        fiber.start(tube, packet, completionCallback2, this.getBinding().isFeatureEnabled(SyncStartForAsyncFeature.class) && !requestContext.containsKey(PREVENT_SYNC_START_FOR_ASYNC_INVOKE));
    }

    protected void configureFiber(Fiber fiber) {
    }

    @Override
    public void close() {
        Object object;
        Pool.TubePool tubePool = (Pool.TubePool)this.tubes;
        if (tubePool != null) {
            object = tubePool.takeMaster();
            object.preDestroy();
            this.tubes = null;
        }
        if (!this.managedObjectManagerClosed) {
            try {
                object = this.managedObjectManager.getObjectName(this.managedObjectManager.getRoot());
                if (object != null) {
                    monitoringLogger.log(Level.INFO, "Closing Metro monitoring root: {0}", object);
                }
                this.managedObjectManager.close();
            }
            catch (IOException iOException) {
                monitoringLogger.log(Level.WARNING, "Ignoring error when closing Managed Object Manager", iOException);
            }
            this.managedObjectManagerClosed = true;
        }
    }

    @Override
    public final WSBinding getBinding() {
        return this.binding;
    }

    @Override
    public final Map<String, Object> getRequestContext() {
        return this.requestContext.asMap();
    }

    public void resetRequestContext() {
        this.requestContext = this.cleanRequestContext.copy();
    }

    public final ResponseContext getResponseContext() {
        return this.responseContext;
    }

    @Override
    public void setResponseContext(ResponseContext responseContext) {
        this.responseContext = responseContext;
    }

    private String getStringId() {
        return RuntimeVersion.VERSION + ": Stub for " + this.getRequestContext().get("javax.xml.ws.service.endpoint.address");
    }

    public String toString() {
        return this.getStringId();
    }

    @Override
    public final WSEndpointReference getWSEndpointReference() {
        Object object;
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException(ClientMessages.UNSUPPORTED_OPERATION("BindingProvider.getEndpointReference(Class<T> class)", "XML/HTTP Binding", "SOAP11 or SOAP12 Binding"));
        }
        if (this.endpointReference != null) {
            return this.endpointReference;
        }
        String string = this.requestContext.getEndpointAddress().toString();
        QName qName = null;
        String string2 = null;
        ArrayList<WSEndpointReference.EPRExtension> arrayList = new ArrayList<WSEndpointReference.EPRExtension>();
        if (this.wsdlPort != null) {
            qName = this.wsdlPort.getBinding().getPortTypeName();
            string2 = string + "?wsdl";
            try {
                object = this.wsdlPort.getEPR();
                if (object != null) {
                    for (WSEndpointReference.EPRExtension ePRExtension : ((WSEndpointReference)object).getEPRExtensions()) {
                        arrayList.add(new WSEPRExtension(XMLStreamBuffer.createNewBufferFromXMLStreamReader(ePRExtension.readAsXMLStreamReader()), ePRExtension.getQName()));
                    }
                }
            }
            catch (XMLStreamException xMLStreamException) {
                throw new WebServiceException(xMLStreamException);
            }
        }
        object = AddressingVersion.W3C;
        this.endpointReference = new WSEndpointReference((AddressingVersion)((Object)object), string, this.getServiceName(), this.getPortName(), qName, null, string2, null, arrayList, null);
        return this.endpointReference;
    }

    @Override
    public final W3CEndpointReference getEndpointReference() {
        if (this.binding.getBindingID().equals("http://www.w3.org/2004/08/wsdl/http")) {
            throw new UnsupportedOperationException(ClientMessages.UNSUPPORTED_OPERATION("BindingProvider.getEndpointReference()", "XML/HTTP Binding", "SOAP11 or SOAP12 Binding"));
        }
        return this.getEndpointReference(W3CEndpointReference.class);
    }

    @Override
    public final <T extends EndpointReference> T getEndpointReference(Class<T> clazz) {
        return this.getWSEndpointReference().toSpec(clazz);
    }

    @Override
    @NotNull
    public ManagedObjectManager getManagedObjectManager() {
        return this.managedObjectManager;
    }

    @Override
    public final void setOutboundHeaders(List<Header> list) {
        if (list == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header header : list) {
                if (header != null) continue;
                throw new IllegalArgumentException();
            }
            this.userOutboundHeaders = list.toArray(new Header[list.size()]);
        }
    }

    @Override
    public final void setOutboundHeaders(Header ... headerArray) {
        if (headerArray == null) {
            this.userOutboundHeaders = null;
        } else {
            for (Header header : headerArray) {
                if (header != null) continue;
                throw new IllegalArgumentException();
            }
            Header[] headerArray2 = new Header[headerArray.length];
            System.arraycopy(headerArray, 0, headerArray2, 0, headerArray.length);
            this.userOutboundHeaders = headerArray2;
        }
    }

    @Override
    public final List<Header> getInboundHeaders() {
        return Collections.unmodifiableList(((MessageHeaders)this.responseContext.get("com.sun.xml.internal.ws.api.message.HeaderList")).asList());
    }

    @Override
    public final void setAddress(String string) {
        this.requestContext.put("javax.xml.ws.service.endpoint.address", string);
    }

    @Override
    public <S> S getSPI(Class<S> clazz) {
        for (Component component : this.components) {
            S s = component.getSPI(clazz);
            if (s == null) continue;
            return s;
        }
        return this.owner.getSPI(clazz);
    }

    @Override
    public Set<Component> getComponents() {
        return this.components;
    }
}

