/*==============================================================*/
/* Skrypt wpisujący dane demo do bazy kasy K17                  */
/*==============================================================*/

/* Informacja o tym, że baza nie jest pusta */
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'IsDatabaseEmpty', 0, '1', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go
INSERT INTO Config (ParamGroup, ParamName, Ordinal, ParamValue, LastUpdate) VALUES ('SQLite', 'DatabaseType', 0, 'demo', strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* PosGroup */
INSERT INTO PosGroup (PosGroupId, Name, IsActive, Creation, LastUpdate) VALUES (1, 'Liniowe', 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Pos */
INSERT INTO Pos (PosId, PosGroupId, type, Name, Number, IsActive, Creation, LastUpdate) VALUES (1, 1, 0, '1', 1, 1, strftime('%Y-%m-%d %H:%M:%f', 'now'), strftime('%Y-%m-%d %H:%M:%f', 'now'))
go

/* Currency */
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (1,1,'zł','PLN',1,1,1,'','2016-06-09 23:14:13.029','2016-06-10 00:01:04.091');
go
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (2,1,'EUR','EUR',4.3535,1,0,'','2016-06-09 23:14:13.064','2016-06-10 00:01:04.127');
go
INSERT INTO Currency (CurrencyId,IsActive,Name,Code,Rate,IsPayoutAllowed,IsDefault,ExternalId,Creation,LastUpdate) VALUES (3,1,'USD','USD',3.8510,1,0,'','2016-06-09 23:14:13.096','2016-06-10 00:01:04.164');
go

/* ShopInfo - dane sklepu */
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','name',0,'Sklep Demo','2016-06-10 00:01:12.098');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','bankaccount',0,'00-0000-0000-0000-0000-0000','2016-06-10 00:01:12.780');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','bankname',0,'Bank Testowy','2016-06-10 00:01:12.813');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','city',0,'Miasteczko','2016-06-10 00:01:12.143');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','street',0,'Testowa 0','2016-06-10 00:01:12.755');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','nip',0,'123-456-78-90','2016-06-10 00:01:12.838');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','phonenumber',0,'099 00000000','2016-06-10 00:01:12.864');
go
INSERT INTO Config (ParamGroup,ParamName,Ordinal,ParamValue,LastUpdate) VALUES ('DaneSklepu','zipcode',0,'00-000','2016-06-10 00:01:12.705');
go

/* PaymentForm */
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (1,1,'Gotówka',0,'null',1,'','2016-06-09 23:14:13.147','2016-06-10 00:01:04.200');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (2,1,'Karta pł.',2,'null',0,'','2016-06-09 23:14:13.687','2016-06-10 00:01:04.230');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (3,1,'Bon pł.',4,'null',0,'','2016-06-09 23:14:13.734','2016-06-10 00:01:04.266');
go
INSERT INTO PaymentForm (PaymentFormId,IsActive,Name,Type,CardPaymentService,IsChangeAllowed,ExternalId,Creation,LastUpdate) VALUES (4,1,'Przelew',5,'null',0,'','2016-06-09 23:14:13.761','2016-06-10 00:01:04.288');
go

/* Operator */
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (1,3,NULL,1,1,'','Jan Kowalski','','','',NULL,'','Jan Kowalski',0,NULL,NULL,'2016-06-09 23:14:12.841','2016-06-10 00:01:03.529');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (2,1,NULL,1,2,'','Anna Wójcik','','','',NULL,'','Anna Wójcik',0,NULL,NULL,'2016-06-09 23:14:12.935','2016-06-10 00:01:03.566');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (3,1,NULL,1,3,'','Paulina Matusik','','','',NULL,'','Paulina Matusik',0,NULL,NULL,'2016-06-09 23:14:12.965','2016-06-10 00:01:04.034');
go
INSERT INTO Operator (OperatorId,ProfileId,PosId,IsActive,Number,FirstName,FamilyName,Description,IdCardCode,ExternalId,CashLimit,Password,LoginName,IsOffLine,PrepaidUser,PrepaidPassword,Creation,LastUpdate) VALUES (4,2,NULL,1,4,'','Eugeniusz Nowak','','','',NULL,'','Eugeniusz Nowak',0,NULL,NULL,'2016-06-09 23:14:12.994','2016-06-10 00:01:04.062');
go

/* Customer */
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (1,NULL,1,'Sklep Novitus 1','Novitus 1','Nowy Sącz','33-300','Nowy Sącz','Nawojowska 118','','',NULL,NULL,'734-10-01-369','18 444 0 720','info@novitus.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,0,0,0,1,0,'','2016-06-09 23:14:14.034','2016-06-09 23:15:28.979',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (2,NULL,1,'"Codziennik" Dostawca Prasy','','Warszawa','00-734','Warszawa','Złotej Jesieni 54','','',NULL,NULL,'123-65-56-567','','codziennik@onet.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:01.762','2016-06-09 23:22:01.762',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (3,NULL,1,'"Gospodarz" Gospodarstwo Rolne','','Turek','62-733','Turek','Zielona 14','','',NULL,NULL,'213-243-24-11','','biuro@gospodarz.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:01.819','2016-06-09 23:22:01.819',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (4,NULL,1,'"Oskarek" Antoni Oskariusz','','Wyszków','65-969','Wyszków','Oskarowa 25','','',NULL,NULL,'365-69-63-123','','info@oskarek.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'','2016-06-09 23:22:01.856','2016-06-09 23:22:01.856',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (5,NULL,1,'F.P.H.U. Józef Kowalczyk','','Gdańsk','80-122','Gdańsk','Nadmorska 134/22','','',NULL,NULL,'987-98-98-999','','jozef@kowalczyk.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'','2016-06-09 23:22:01.890','2016-06-09 23:22:01.890',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (6,NULL,1,'Firma Handlowa „Komputerek”','','Suwałki','16-400','Suwałki','Źródlana 151','','',NULL,NULL,'345-65-65-765','','biuro@komputerek.info',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:01.923','2016-06-09 23:22:01.923',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (7,NULL,1,'Firma Handlowo-Usługowa „Tęcza”','','Kraków','30-205','Kraków','Warszawska  77','','',NULL,NULL,'777-12-23-154','','salon@tecza.com',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:01.960','2016-06-09 23:22:01.960',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (8,NULL,1,'Hurtownia Sprzętu AGD','','Bartoszyce','11-276','Bartoszyce','Plac Teatralny 23','','',NULL,NULL,'763-88-99-098','','agd@hurtownia.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:01.997','2016-06-09 23:22:01.997',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (9,NULL,1,'Hurtownia Techniczna „Technet”','','Siedlce','08-134','Siedlce','Alpejska 99','','',NULL,NULL,'321-32-32-432','','office@technet.com',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:02.029','2016-06-09 23:22:02.029',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (10,NULL,1,'Mleczarnia „Łaciata”','','Grudziądz','86-330','Grudziądz','11 Listopada 87','','',NULL,NULL,'521-52-51-213','','laciata@krowa.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:02.060','2016-06-09 23:22:02.060',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (11,NULL,1,'Piekarnia „Złoty łan”','','Śrem','63-115','Śrem','Poprzeczna 4','','',NULL,NULL,'654-43-43-456','','info@zloty.com',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:02.106','2016-06-09 23:22:02.106',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (12,NULL,1,'Polskie Zakłady Spirytusowe "Polmos"','','Biała Podlaska','21-534','Biała Podlaska','Kajakowa 267','','',NULL,NULL,'376-76-76-376','','polmos@polmos.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:02.139','2016-06-09 23:22:02.139',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (13,NULL,1,'Przedsiębiorstwo Przemysłowe  „Metaleks”','','Mińsk Mazowiecki','05-321','Mińsk Mazowiecki','Deptak 83','','',NULL,NULL,'666-54-45-777','','biuro@metaleks.com',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:02.170','2016-06-09 23:22:02.170',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (14,NULL,1,'Szkoła Podstawowa nr 144','','Katowice','40-350','Katowice','Marynarska 45','','',NULL,NULL,'234-56-78-901','','144@szkoly.info',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,0,0,0,'','2016-06-09 23:22:02.204','2016-06-09 23:22:02.204',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (15,NULL,1,'Wytwórnia Butów Sportowych','','Poznań','61-005','Poznań','Kazimierza Wielkiego 45/15','','',NULL,NULL,'901-01-01-110','','relax@buty.info',NULL,NULL,NULL,NULL,NULL,NULL,0,1,1,1,0,0,'','2016-06-09 23:22:02.237','2016-06-09 23:22:02.237',NULL,NULL,NULL,'','','','',NULL,NULL);
go
INSERT INTO Customer (CustomerId,LevelNumber,IsActive,Name,AbbrevName,Town,PostalCode,PostalName,Street,House,ApartmentNo,BankName,BankAccount,Nip,Phone,Email,LoyaltyPoints,DiscountRate,DefaultPaymentForm,DefaultPriceLevel,DefaultPaymentTerm,ShopNumber,IsRetailCustomer,IsCustomer,IsManufacturer,IsSupplier,IsShop,IsCentralStore,Externalid,Creation,LastUpdate,EdiFormat,SyncLastUpdate,CountryId,Wojewodztwo,Powiat,Gmina,USCode,VatPayerStatus,VatPayerStatusDate) VALUES (16,NULL,1,'Zakład Produkcji Odzieży','','Stargard','73-100','Stargard','Samorządowa 15b','','',NULL,NULL,'871-12-12-345','','zamowienia@odziez.pl',NULL,NULL,NULL,NULL,NULL,NULL,0,1,0,1,0,0,'','2016-06-09 23:22:02.268','2016-06-09 23:22:02.268',NULL,NULL,NULL,'','','','',NULL,NULL);
go

/* ProductGroup */
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (1,1,'Chemia',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.809','2016-06-10 00:01:04.330',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (2,1,'Kawy',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.836','2016-06-10 00:01:04.353',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (3,1,'Kosmetyki',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.863','2016-06-10 00:01:04.376',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (4,1,'Napoje',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.892','2016-06-10 00:01:04.401',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (5,1,'Owoce i warzywa',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.919','2016-06-10 00:01:04.428',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (6,1,'Pieczywo',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.944','2016-06-10 00:01:04.454',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (7,1,'Słodycze',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.977','2016-06-10 00:01:04.516',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (8,1,'Zestawy',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.977','2016-06-10 00:01:04.516',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (9,1,'Opakowania',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.977','2016-06-10 00:01:04.516',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (10,1,'Dania obiadowe',NULL,NULL,0,0,0,'','2016-06-09 23:14:13.977','2016-06-10 00:01:04.516',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (11,1,'Usługi',NULL,NULL,0,0,0,'','2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',0,0,0,0);
go
INSERT INTO ProductGroup (GroupId,IsActive,Name,GroupType,GroupLevel,CustomerAge,QuantityRequired,WeightRequired,ExternalId,Creation,LastUpdate,SerialNumberRequired,HiddenOnPanels,HiddenOnBiller,IsExisable) VALUES (12,1,'Alkohole',NULL,NULL,0,0,0,'','2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',0,0,0,0);
go

/* VatRate */
INSERT INTO VatRate (VatRateId,IsActive,Value,ExternalId,Creation,LastUpdate) VALUES (1,1,-1,'','2016-06-09 23:14:00.248','2016-06-10 00:01:03.316');
go
INSERT INTO VatRate (VatRateId,IsActive,Value,ExternalId,Creation,LastUpdate) VALUES (2,1,0,'','2016-06-09 23:14:00.331','2016-06-10 00:01:03.349');
go
INSERT INTO VatRate (VatRateId,IsActive,Value,ExternalId,Creation,LastUpdate) VALUES (3,1,500,'','2016-06-09 23:14:00.355','2016-06-10 00:01:03.370');
go
INSERT INTO VatRate (VatRateId,IsActive,Value,ExternalId,Creation,LastUpdate) VALUES (4,1,800,'','2016-06-09 23:14:00.386','2016-06-10 00:01:03.393');
go
INSERT INTO VatRate (VatRateId,IsActive,Value,ExternalId,Creation,LastUpdate) VALUES (5,1,2300,'','2016-06-09 23:14:00.419','2016-06-10 00:01:03.420');
go

/* VatRateLtr */
INSERT INTO VatRateLtr (Letter,Value) VALUES ('A',2300);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('B',800);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('C',500);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('D',0);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('E',-1);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('F',-2);
go
INSERT INTO VatRateLtr (Letter,Value) VALUES ('G',-2);
go

/* UnitName */
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (1,1,'kg',-3,'','2016-06-09 23:14:00.450','2016-06-10 00:01:03.447');
go
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (2,1,'opak',0,'','2016-06-09 23:14:00.492','2016-06-10 00:01:03.472');
go
INSERT INTO UnitName (UnitNameId,IsActive,Name,Precission,ExternalId,Creation,LastUpdate) VALUES (3,1,'szt',0,'','2016-06-09 23:14:00.524','2016-06-10 00:01:03.496');
go

/* Product */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (1,1,4,3,NULL,5,NULL,'7 UP Napój Gazowany puszka 250ml','',1.8,1.8,1.8,1.8,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.216','2016-06-09 23:31:09.682',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (2,1,4,3,NULL,5,NULL,'Cappy Sok Pomarańczowy 330ml','',2.6,2.6,2.6,2.6,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.227','2016-06-09 23:18:11.657',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (3,1,4,3,NULL,5,NULL,'Cisowianka Woda Mineralna Gazowana 1.5l','',1.95,1.95,1.95,1.95,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.235','2016-06-09 23:18:11.680',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (4,1,4,3,NULL,5,NULL,'Coca-Cola Napój Gazowany Puszka 250ml','',2.4,2.4,2.4,2.4,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.245','2016-06-09 23:18:11.708',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (5,1,4,3,NULL,5,NULL,'Coca-Cola Napój Gazowany 1l','',4.5,4.5,4.5,4.5,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.253','2016-06-09 23:31:09.691',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (6,1,4,3,NULL,5,NULL,'Fanta Pomarańczowa Napój Gazowany 1l','',4.2,4.2,4.2,4.2,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.262','2016-06-09 23:18:11.765',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (7,1,4,3,NULL,5,NULL,'Garden Napój Jabłko Antonówka 2l','',5.2,5.2,5.2,5.2,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.271','2016-06-09 23:18:11.787',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (8,1,4,3,NULL,5,NULL,'Garden Napój Pomarańczowy 2l','',3.5,3.5,3.5,3.5,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.280','2016-06-09 23:18:11.805',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (9,1,4,3,NULL,5,NULL,'Kropla Beskidu Woda Mineralna Gazowana 1.5l','',2.5,2.5,2.5,2.5,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.288','2016-06-09 23:18:11.824',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (10,1,4,3,NULL,5,NULL,'Nestle Aquarel Napój Niegazowany 0,5l','',2,2,2,2,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.296','2016-06-09 23:18:11.837',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (11,1,4,3,NULL,5,NULL,'Pepsi Napój Gazowany 1l','',4.4,4.4,4.4,4.4,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.305','2016-06-09 23:57:55.641',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (12,1,4,3,NULL,5,NULL,'Sprite Napój Gazowany 1l','',4.1,4.1,4.1,4.1,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.314','2016-06-09 23:18:11.886',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (13,1,4,3,NULL,5,NULL,'Tymbark Napój Jabłkowo-Miętowy 250ml','',2.3,2.3,2.3,2.3,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.322','2016-06-09 23:18:11.900',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (14,1,4,3,NULL,5,NULL,'Tymbark Sok Jabłkowy 0,2l','',0.9,0.9,0.9,0.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.330','2016-06-09 23:18:11.913',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (15,1,4,3,NULL,5,NULL,'Kubuś Sok Marchwiowo-Truskawkowy 330ml','',2,2,2,2,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.338','2016-06-09 23:18:11.930',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (16,1,7,3,NULL,5,NULL,'Alpejskie Mleczko 380g.Waniliowe','',15.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.346','2016-06-09 23:18:11.941',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (17,1,7,3,NULL,5,NULL,'Baton Grześki Kakaowe 27g','',1.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.356','2016-06-09 23:18:11.951',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (18,1,7,3,NULL,5,NULL,'Baton Grześki Orzechowe 39g','',1.1,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.367','2016-06-09 23:18:11.960',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (19,1,7,3,NULL,5,NULL,'Baton Kinder Delice Kakao','',2.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.379','2016-06-09 23:18:11.969',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (20,1,7,3,NULL,5,NULL,'Baton Lion Peanut 41g','',1.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.392','2016-06-09 23:18:11.978',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (21,1,7,3,NULL,5,NULL,'Baton Mars','',1.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.405','2016-06-09 23:18:11.987',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (22,1,7,3,NULL,5,NULL,'Baton Maxser Xxl 51g','',1.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.459','2016-06-09 23:18:11.995',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (23,1,7,3,NULL,5,NULL,'Baton Mc Kokosowy W Czeko. 40','',1,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.485','2016-06-09 23:18:12.004',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (24,1,7,3,NULL,5,NULL,'Baton Milky Way 25g','',1.3,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.493','2016-06-09 23:18:12.012',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (25,1,7,3,NULL,5,NULL,'Baton Pawełek Adwokat 45g','',1.6,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.501','2016-06-09 23:57:55.665',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (26,1,7,3,NULL,5,NULL,'Baton Prince Polo Mleczne Xxl','',1.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.508','2016-06-09 23:18:12.030',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (27,1,7,3,NULL,5,NULL,'Ciastka Delicje Pomara.294g','',5.99,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.516','2016-06-09 23:18:12.039',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (28,1,7,3,NULL,5,NULL,'Ciastka Delicje Wiśniowe 294g','',5.99,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.524','2016-06-09 23:18:12.048',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (29,1,7,3,NULL,5,NULL,'Ciastka Familijne 180g','',3.8,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.532','2016-06-09 23:18:12.057',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (30,1,7,3,NULL,5,NULL,'Czekolada E.Wedel Mleczna','',3.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.540','2016-06-09 23:18:12.066',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (31,1,7,3,NULL,5,NULL,'Guma Airwaves Classic Torebka','',3.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.548','2016-06-09 23:18:12.074',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (32,1,7,3,NULL,5,NULL,'Guma Orbit Aple Torebka','',3.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.555','2016-06-09 23:18:12.083',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (33,1,1,3,NULL,5,NULL,'Chusteczki Higieniczne','',1,1,1,1,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.563','2016-06-09 23:18:12.091',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (34,1,2,3,NULL,5,NULL,'Kawa Jacobs Kronung 100g','',5.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.570','2016-06-09 23:18:12.100',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (35,1,2,3,NULL,5,NULL,'Kawa Pedros 100g','',6.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.578','2016-06-09 23:18:12.109',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (36,1,2,3,NULL,5,NULL,'Kawa Tchibo Exclusive 100g','',7.2,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.585','2016-06-09 23:18:12.117',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (37,1,7,3,NULL,5,NULL,'Orzeszki Felix 300g Papryka','',9,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.592','2016-06-09 23:18:12.126',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (38,1,7,3,NULL,5,NULL,'Paluszki Junor Safari 125g','',3.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.599','2016-06-09 23:18:12.134',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (39,1,7,3,NULL,5,NULL,'Ptasie Mleczko Waniliowe 420g','',15.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.607','2016-06-09 23:18:12.143',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (40,1,2,3,NULL,5,NULL,'Kawa Nescafe 250g','',17.3,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.614','2016-06-09 23:18:12.151',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (41,1,2,3,NULL,5,NULL,'Kawa Lavazza 500g','',28.5,0,0,0,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.621','2016-06-09 23:57:55.690',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (42,1,4,3,NULL,5,NULL,'Natural Active Woda Źródlana 1.5l','',3,3,3,3,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.628','2016-06-09 23:18:12.168',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (43,1,4,3,NULL,5,NULL,'Frugo Czerwone Napój Owocowy 250ml','',1.25,1.25,1.25,1.25,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.637','2016-06-09 23:23:46.562',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (44,1,4,3,NULL,5,NULL,'Hortex Vitaminka Napój Marchew-Jabłko 250ml','',1.65,1.65,1.65,1.65,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.644','2016-06-09 23:22:45.456',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (45,1,4,3,NULL,5,NULL,'Black Sex Napój Energetyczny Puszka 250ml','',1.9,1.9,1.9,1.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.653','2016-06-09 23:18:12.198',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (46,1,4,3,NULL,5,NULL,'Red Bull Napój Energetyczny Puszka 250ml','',5.55,5.55,5.55,5.55,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.661','2016-06-09 23:18:12.208',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (47,1,6,3,NULL,4,NULL,'Chleb razowy ze słonecznikiem','',5.79,5.79,5.79,5.79,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.669','2016-06-09 23:18:12.217',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (48,1,6,3,NULL,4,NULL,'Chleb z czarnuszką z Piekarni Ziarno','',3.39,3.39,3.39,3.39,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.675','2016-06-09 23:22:45.463',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (49,1,6,3,NULL,4,NULL,'Chleb wiejski pszenny na drożdżach Piekarnia Madej','',3.39,3.39,3.39,3.39,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.681','2016-06-09 23:22:45.471',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (50,1,6,3,NULL,4,NULL,'Chleb żytni tradycyjny na zakwasie','',5.3,5.3,5.3,5.3,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.688','2016-06-09 23:18:12.238',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (51,1,6,3,NULL,4,NULL,'Bagietka czosnkowa - wypiekana na miejscu','',3.49,3.49,3.49,3.49,NULL,NULL,NULL,0,'',0,0,NULL,NULL,'','2016-06-09 23:14:17.694','2016-06-09 23:18:12.245',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (52,1,5,1,NULL,4,NULL,'Pomidory malinowe świeże','',7.99,7.99,7.99,7.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.701','2016-06-09 23:18:12.252',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (53,1,5,3,NULL,4,NULL,'Rzodkiewka pęczek','',1.49,1.49,1.49,1.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.707','2016-06-09 23:18:12.259',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (54,1,5,3,NULL,4,NULL,'Avokado extra','',4.99,4.99,4.99,4.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.714','2016-06-09 23:18:12.266',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (55,1,5,1,NULL,4,NULL,'Ziemniaki młode','',4.39,4.39,4.39,4.39,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.721','2016-06-09 23:18:12.273',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (56,1,5,3,NULL,4,NULL,'Szczypiorek pęczek','',0.99,0.99,0.99,0.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.727','2016-06-09 23:18:12.280',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (57,1,5,3,NULL,4,NULL,'Pomidory koktajlowe cherry 500g','',5.99,5.99,5.99,5.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.733','2016-06-09 23:47:19.355',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (58,1,5,1,NULL,4,NULL,'Ogórek polski szklarniowy','',4.49,4.49,4.49,4.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.739','2016-06-09 23:18:12.294',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (59,1,5,1,NULL,4,NULL,'Jabłka z polskich sadów','',2.99,2.99,2.99,2.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.746','2016-06-09 23:18:12.301',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (60,1,5,3,NULL,4,NULL,'Papryka czerwona','',9.99,9.99,9.99,9.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.753','2016-06-09 23:18:12.309',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (61,1,5,1,NULL,4,NULL,'Kapusta pekińska','',2.99,2.99,2.99,2.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.759','2016-06-09 23:18:12.317',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (62,1,3,3,NULL,5,NULL,'Colgate Total Original pasta do zębów 100ml','',8.99,8.99,8.99,8.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.765','2016-06-09 23:18:12.327',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (63,1,3,3,NULL,5,NULL,'Palmolive Men Fresh żel pod prysznic 500ml','',14.99,14.99,14.99,14.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.774','2016-06-09 23:18:12.337',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (64,1,3,3,NULL,5,NULL,'Mydło w płynie jabłkowe 400ml','',9.99,9.99,9.99,9.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.782','2016-06-09 23:18:12.347',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (65,1,1,3,NULL,5,NULL,'Perlux White Kapsułki do prania 24 szt.','',29.99,29.99,29.99,29.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.791','2016-06-09 23:18:12.358',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (66,1,1,3,NULL,5,NULL,'Velvet Jumbo Ręcznik papierowy','',16.99,16.99,16.99,16.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.799','2016-06-09 23:18:12.369',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (67,1,1,3,NULL,5,NULL,'Ajax Floral Fiesta Konwalie Płyn uniwersalny 1l','',8.99,8.99,8.99,8.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.807','2016-06-09 23:57:55.724',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (68,1,3,3,NULL,5,NULL,'Dove Kremowa kostka myjąca 100 g','',3.19,3.19,3.19,3.19,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.816','2016-06-09 23:18:12.391',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (69,1,3,3,NULL,5,NULL,'STR8 original Dezodorant 150ml','',14.99,14.99,14.99,14.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.824','2016-06-09 23:18:12.400',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (70,1,3,3,NULL,5,NULL,'Dove Men plus Antyperspirant w sztyfcie 50 ml','',15.99,15.99,15.99,15.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.832','2016-06-09 23:18:12.410',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (71,1,3,3,NULL,5,NULL,'Dove Natural Touch Dead Sea Minerals 150 ml','',14.99,14.99,14.99,14.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.841','2016-06-09 23:18:12.419',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (72,1,3,3,NULL,5,NULL,'Rexona Sexy Bouquet dezodorant 150ml','',13.49,13.49,13.49,13.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.849','2016-06-09 23:18:12.428',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (73,1,3,3,NULL,5,NULL,'Nivea Men Stress Protect 48 h w kulce 50 ml','',12.49,12.49,12.49,12.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.857','2016-06-09 23:28:17.483',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (74,1,3,3,NULL,5,NULL,'Gillette Series Żel do golenia 200 ml','',14.99,14.99,14.99,14.99,NULL,NULL,NULL,0,'',0,0,NULL,NULL,'','2016-06-09 23:14:17.865','2016-06-09 23:18:12.447',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (75,1,3,3,NULL,5,NULL,'Nivea Men Invisible for Black and White 150 ml','',12.49,12.49,12.49,12.49,NULL,NULL,NULL,0,'',0,0,NULL,NULL,'','2016-06-09 23:14:17.874','2016-06-09 23:27:57.167',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (76,1,3,3,NULL,5,NULL,'Nivea Creme Krem 50 ml','',4.49,4.49,4.49,4.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.884','2016-06-09 23:57:55.754',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (77,1,3,3,NULL,5,NULL,'Nivea Men Sport Żel pod prysznic 250 ml','',9.99,9.99,9.99,9.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.895','2016-06-09 23:28:07.230',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (78,1,3,3,NULL,5,NULL,'Ziaja Yego Dezodorant antyperspirant roll-on','',6.99,6.99,6.99,6.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.910','2016-06-09 23:18:12.484',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (79,1,3,3,NULL,5,NULL,'Fa Sport Energizing Fresh Dezodorant 150 ml','',8.99,8.99,8.99,8.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.924','2016-06-09 23:18:12.493',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (80,1,1,3,NULL,5,NULL,'Woolite Perła Extra Płyn do prania 2 l','',19.99,19.99,19.99,19.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.949','2016-06-09 23:18:12.502',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (81,1,1,3,NULL,5,NULL,'Cif Ultra Biel Mleczko z wybielaczem 700 ml','',9.99,9.99,9.99,9.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.958','2016-06-09 23:18:12.511',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (82,1,1,3,NULL,5,NULL,'Vanish Oxi Action Odplamiacz do tkanin 500 g','',29.99,29.99,29.99,29.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.966','2016-06-09 23:18:12.526',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (83,1,1,3,NULL,5,NULL,'Cillit Kamień i rdza Żel 450 g','',15.9,15.9,15.9,15.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.975','2016-06-09 23:18:12.540',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (84,1,1,3,NULL,5,NULL,'Mr Muscle 5w1Płyn w rozpylaczu 500 ml','',10.49,10.49,10.49,10.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.983','2016-06-09 23:18:12.557',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (85,1,1,3,NULL,5,NULL,'Płyn do szyb cytrusowy 500ml','',5.99,5.99,5.99,5.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.991','2016-06-09 23:18:12.573',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (86,1,1,3,NULL,5,NULL,'Biały Jeleń Hipoalergiczny balsam do naczyń 1l','',6.99,6.99,6.99,6.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:17.999','2016-06-09 23:25:57.333',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (87,1,1,3,NULL,5,NULL,'Glade by Brise odświeżacz powietrza 269ml','',26.9,26.9,26.9,26.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.008','2016-06-09 23:18:12.614',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (88,1,1,3,NULL,5,NULL,'Frosch żel do zmywarki limonkowy 650 ml','',29.99,29.99,29.99,29.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.016','2016-06-09 23:18:12.625',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (89,1,1,3,NULL,5,NULL,'Air Wick Freshmatic Max Wkład 250 ml','',20.99,20.99,20.99,20.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.025','2016-06-09 23:18:12.634',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (90,1,1,3,NULL,5,NULL,'Biały Jeleń Hipoalerg proszek do prania 500g','',7.99,7.99,7.99,7.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.033','2016-06-09 23:25:36.646',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (91,1,1,3,NULL,5,NULL,'JELP Gel Color Hipoalergiczny żel 1 L','',26.9,26.9,26.9,26.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.041','2016-06-09 23:18:12.653',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (92,1,1,3,NULL,5,NULL,'Visir Color Proszek do prania 300g','',4.79,4.79,4.79,4.79,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.050','2016-06-09 23:18:12.662',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (93,1,1,2,NULL,5,NULL,'Ariel Color Proszek do prania 300 g','',6.99,6.99,6.99,6.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.058','2016-06-09 23:18:12.672',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (94,1,1,3,NULL,5,NULL,'Perwoll Wool&Silk Płyn do prania wełny 2 l','',21.9,21.9,21.9,21.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.066','2016-06-09 23:18:12.682',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (95,1,1,3,NULL,5,NULL,'ACE Wybielacz 1l cytrynowy','',7.99,7.99,7.99,7.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.074','2016-06-09 23:18:12.695',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (96,1,1,2,NULL,5,NULL,'Jan Niezbędny Ściereczki nasączane 40 sztuk','',7.99,7.99,7.99,7.99,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.083','2016-06-09 23:18:12.707',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (97,1,1,3,NULL,5,NULL,'Cillit Bang spray - Kamień i Brud 750ml','',16.49,16.49,16.49,16.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.091','2016-06-09 23:18:12.717',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (98,1,1,3,NULL,5,NULL,'Ajax Spray do łazienki 500ml','',12.9,12.9,12.9,12.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.099','2016-06-09 23:18:12.727',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (99,1,1,3,NULL,5,NULL,'Kret Żel do udrożniania rur','',13.9,13.9,13.9,13.9,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.107','2016-06-09 23:18:12.737',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (100,1,1,3,NULL,5,NULL,'Pronto 5in1 Płyn do paneli 750 ml','',15.49,15.49,15.49,15.49,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2016-06-09 23:14:18.115','2016-06-09 23:18:12.746',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'',-999,0,0,0,0,'',0);
go
/* Zestawy */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (101,1,7,3,NULL,5,NULL,'Domowa szarlotka z lodami',      '',18,18,18,18,NULL,NULL,NULL,0,'',1,0,NULL,1,   '','2013-09-16 16:54:18.462','2013-09-16 16:54:18.462',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(102,1,4,3,NULL,5,NULL,'Cappuccino',                      '',15,15,15,15,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:55:05.044','2013-09-16 16:55:05.045',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(103,1,4,3,NULL,5,NULL,'Coca Cola',                       '',8,8,8,8,    NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:37.658','2013-09-16 16:54:37.658',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(104,1,4,3,NULL,5,NULL,'Coca Cola Light',                 '',7,7,7,7,    NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:39.396','2013-09-16 16:54:39.396',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(105,1,4,3,NULL,5,NULL,'Coca Cola Zero',                  '',6,6,6,6,    NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:38.624','2013-09-16 16:54:38.624',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(106,1,4,3,NULL,5,NULL,'Fanta',                           '',8,8,8,8,    NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:40.288','2013-09-16 16:54:40.288',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(107,1,4,3,NULL,5,NULL,'Nestea',                          '',8,8,8,8,    NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:50.700','2013-09-16 16:54:50.700',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(108,1,4,3,NULL,5,NULL,'Herbata Ronnefeldt Leaf Cup',     '',10,10,10,10,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-09-16 16:54:56.889','2013-09-16 16:54:56.889',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(109,1,8,3,NULL,5,NULL,'Szarlotka i napój w super cenie!','',17,17,17,17,NULL,NULL,NULL,6,'',1,0,NULL,NULL,'','2013-12-20 12:06:39.523','2013-12-20 12:06:39.525',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
/* Tandemy */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(110,1,4,3,111,5,NULL,'Piwo 0.5 z kaucją',            '',6.5,6.5,6.5,6.5,NULL,NULL,NULL,0,'',1,0,NULL,NULL,'','2013-12-20 12:06:39.523','2013-12-20 12:06:39.525',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES(111,1,9,3,NULL,1,NULL,'Butelka 0.5',                 '',0.5,0.5,0.5,0.5,NULL,NULL,NULL,1,'',1,0,NULL,NULL,'','2013-12-20 12:06:39.523','2013-12-20 12:06:39.525',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,-999,0,0,0,0,'',0);
go
/* Znów zestawy */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (112,1,8,3,NULL,5,NULL,'Koszyk prezentów',                    '',20,20,20,20,NULL,NULL,NULL,6,'',0,0,NULL,NULL,'',          '2017-04-14 12:28:20.802','2017-04-14 12:33:10.376',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (113,1,8,3,NULL,5,NULL,'Trzecia cola za pół ceny',            '',1,1,1,1,    NULL,NULL,NULL,6,'',0,0,NULL,NULL,'',          '2017-04-14 12:47:31.542','2017-04-14 12:53:16.147',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (114,1,10,3,NULL,5,NULL,'Rosół gospodyni domowej',            '',15,15,15,15,NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:53:22.429','2013-09-16 16:53:22.430',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (115,1,10,3,NULL,5,NULL,'Czerwony barszcz z kołdunami',       '',18,18,18,18,NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:53:24.818','2013-09-16 16:53:24.818',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (116,1,10,3,NULL,5,NULL,'Sztandarowy Żur',                    '',18,18,18,18,NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:53:17.945','2013-09-16 16:53:17.945',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (117,1,10,3,NULL,5,NULL,'Golonka Ericha - nasz specjał!',     '',37,37,37,37,NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:53:45.117','2013-09-16 16:53:45.117',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (118,1,10,3,NULL,5,NULL,'Bliny Wołodii z łososiem i kawiorem','',36,36,36,36,NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:52:51.985','2013-09-16 16:52:51.985',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (119,1,10,3,NULL,5,NULL,'Frytki',                             '',8,8,8,8,    NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:54:25.502','2013-09-16 16:54:25.502',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (120,1,10,3,NULL,5,NULL,'Ziemniaki po polsku',                '',8,8,8,8,    NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:54:20.860','2013-09-16 16:54:20.860',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (121,1,10,3,NULL,5,NULL,'Ziemniaki z wody',                   '',6,6,6,6,    NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:54:22.291','2013-09-16 16:54:22.291',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (122,1,10,3,NULL,5,NULL,'Ziemniaki tłuczone',                 '',7,7,7,7,    NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:54:24.393','2013-09-16 16:54:24.394',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,KitchenPrinterNumbers,IsSplitPayment) VALUES (123,1,10,3,NULL,5,NULL,'Buraczki zasmażane',                 '',7,7,7,7,    NULL,NULL,NULL,0,'',0,0,NULL,1,   '',          '2013-09-16 16:54:35.651','2013-09-16 16:54:35.651',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,'1',0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (124,1,8,3,NULL,5,NULL,'Zestaw obiadowy 1',                   '',17,17,17,17,NULL,NULL,NULL,6,'',0,0,NULL,0,'','',          '2017-04-20 21:32:44.927','2017-04-20 21:50:23.988',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
/* Usługi gastronomiczne */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (125,1,11,3,NULL,5,NULL,'Usł. gastron. 23%',                  '',0,0,0,0,    NULL,NULL,NULL,2,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (126,1,11,3,NULL,5,NULL,'Usł. katering. 23%',                 '',0,0,0,0,    NULL,NULL,NULL,2,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (127,1,11,3,NULL,4,NULL,'Usł. katering. 8%',                  '',0,0,0,0,    NULL,NULL,NULL,2,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
/* Alkohole */
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (128,1,12,3,NULL,5,NULL,'TATRA NP ZW Skrz. 20x500ml',          '',1.83,1.83,1.83,1.83,    NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (129,1,12,3,NULL,5,NULL,'TATRA JP ZW Skrz. 20x500ml 507a',     '',2.70,2.70,2.70,2.70,    NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (130,1,12,3,NULL,5,NULL,'ŻYWIEC Pusz. Zgrz. 6(4x500ml)',       '',2.73,2.73,2.73,2.73,    NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (131,1,12,3,NULL,5,NULL,'ŻYWIEC ZW Skrz. 20x500ml',            '',3.39,3.39,3.39,3.39,    NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (132,1,12,3,NULL,5,NULL,'ŻYWIEC ZW Skrz. 20x500ml',            '',64.41,64.41,64.41,64.41,NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (133,1,12,3,NULL,5,NULL,'TATRA JP ZW Skrz. 20x500ml 507a',     '',51.30,51.30,51.30,51.30,NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (134,1,12,3,NULL,5,NULL,'TATRA NP ZW Skrz. 20x500ml',          '',34.77,34.77,34.77,34.77,NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go
INSERT INTO Product (ProductId,IsActive,GroupId,UnitNameId,PackageId,VatRateId,ManufacturerId,Name,AbbrevName,Price1,Price2,Price3,Price4,PriceMin,PricePurchaseNetto,PriceForUnit,ProductType,Pkwiu,PriceModifyLevel,IsExisable,AdditionalFiscalPrinter,KitchenPrinterNumber,KitchenPrinterNumbers,ExternalId,Creation,LastUpdate,Tara,CustomerAge,QuantityRequired,WeightRequired,AdditionalDiscount,IsFuel,LotControl,IsPending,SerialNumberRequired,IsLocalProduct,PackageMultiplier,PressIndex,PressMutation,SyncLastUpdate,Indeks,HideOnPos,Favorite,ImageLink,Precission,SoldAmount,SoldValue,StockAmount,StockBlocked,IsSplitPayment) VALUES (135,1,12,3,NULL,5,NULL,'ŻYWIEC Pusz. Zgrz. 6(4x500ml)',       '',4.17,4.17,4.17,4.17,    NULL,NULL,NULL,0,'',1,0,NULL,0,'','',          '2017-08-07 00:00:00.000','2017-08-07 00:00:00.000',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,0,'',-999,0,0,0,0,0);
go

/* Barcode */
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000147042',2,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2003',2,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5902078000102',3,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2004',3,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000000996',4,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2006',4,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000006271',6,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2007',6,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901886010228',7,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2009',7,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901886010259',8,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2010',8,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000114099',9,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2012',9,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3700123303282',10,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2015',10,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000050939',12,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2018',12,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900334000859',13,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2019',13,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900334012746',14,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2020',14,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901067453028',15,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2013',15,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7622300332150',16,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2021',16,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900394005528',17,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2022',17,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900394003548',18,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2023',18,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8000500042854',19,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2024',19,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900862017886',20,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2025',20,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900951016219',21,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2026',21,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7613032546700',22,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2027',22,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5905784308760',23,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2028',23,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4011165098567',24,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2029',24,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901480012246',26,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2031',26,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5906747308582',27,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2032',27,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5906747308612',28,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2033',28,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900352006284',29,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2034',29,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901588016016',30,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2035',30,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009900412711',31,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2036',31,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009900437349',32,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2037',32,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2504',33,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5029053031255',33,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901480001134',34,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5001',34,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900788400137',35,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5004',35,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900839852861',36,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5005',36,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900571001282',37,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2038',37,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900320003420',38,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2039',38,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901588056029',39,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2040',39,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8594003840340',40,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5003',40,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497012416',42,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2014',42,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900552042020',45,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2002',45,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('9002490100193',46,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2017',46,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('501',47,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('504',50,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('505',51,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1001',52,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1002',53,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1003',54,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1004',55,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1005',56,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1007',58,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1008',59,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1009',60,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1010',61,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1501',62,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8714789554679',62,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1503',63,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8718951031050',63,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1504',64,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901549987508',64,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2502',65,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5907542740003',65,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2503',66,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5029053037172',66,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1508',68,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8000700000005',68,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1502',69,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5201314048800',69,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1505',70,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('50220021',70,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1506',71,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8711600682764',71,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1507',72,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8712561845069',72,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1512',74,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('7702018837830',74,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1510',78,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901887019732',78,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1515',79,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3838824085272',79,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2505',80,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627050547',80,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2506',81,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8711600304741',81,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2507',82,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627030983',82,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2508',83,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627011128',83,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2509',84,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5000204746273',84,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2510',85,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901832490500',85,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2512',87,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5000204731934',87,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2513',88,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4009175936776',88,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2514',89,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627047226',89,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2516',91,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5720233358437',91,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2517',92,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4084500723351',92,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2518',93,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4084500702899',93,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2519',94,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('9000100258968',94,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2520',95,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8001480022713',95,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2521',96,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900536273723',96,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2522',97,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900627059014',97,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2523',98,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('8718951012264',98,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2524',99,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900931008982',99,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2525',100,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4000290939505',100,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900500024764',44,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2011',44,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('502',48,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('503',49,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900552039082',43,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2008',43,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2515',90,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900133007905',90,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2511',86,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900133006496',86,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1513',75,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4005808729890',75,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1509',77,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4005808782390',77,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1511',73,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('42236863',73,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497340335',1,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2001',1,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5449000054227',5,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2005',5,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1006',57,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900497311014',11,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2016',11,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5903232843562',25,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2030',25,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901067455022',41,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5002',41,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('2501',67,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900273472939',67,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1514',76,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900017304007',76,0,1,'',1,0,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1011',101,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1012',102,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1013',103,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1014',104,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1015',105,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1016',106,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1017',107,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1018',108,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3003',109,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1020',110,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1021',111,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3001',112,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3002',113,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1031',114,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1032',115,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1033',116,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1034',117,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1035',118,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1036',119,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1037',120,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1038',121,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1039',122,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('1040',123,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('3004',124,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4001',125,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4002',126,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('4003',127,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559953760',128,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559830009',129,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559140009',130,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559130000',131,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699001829',132,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699001799',133,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5900699002604',134,1,1,'',1,NULL,'');
go
INSERT INTO Barcode (Code,ProductId,IsDefault,Multiplier,ProductName,PriceLevel,Price,CodeTango) VALUES ('5901559146001',135,1,1,'',1,NULL,'');
go


/* ProductDescription */
/*INSERT INTO ProductDescription VALUES(101,0,0,'wypiekana z jabłek ogrodowych z dodatkiem soczystych brzoskwiń, podawana z kremowymi lodami waniliowymi');*/
/*go*/

/* GastroElement */
INSERT INTO GastroElement VALUES(109,0,2,'Szarlotka',0,1,1,0);
go
INSERT INTO GastroElement VALUES(109,1,2,'Napój',1.99,1,0,1);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (112,0,0,'Produkty',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (113,0,2,'Pierwsze dwie',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (113,1,1,'Trzecia',0,1,1,1);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (124,0,2,'Danie główne',0,1,1,0);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (124,1,2,'Zupa',0,1,1,1);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (124,2,3,'Dodatki',3,1,0,2);
go
INSERT INTO GastroElement (GastroSetProductId,Ordinal,Type,Name,Price,Quantity,IsDifferentPrice,GastroElementOrdinal) VALUES (124,3,3,'Napoje',0,1,1,3);
go

/* GastroElementList */
INSERT INTO GastroElementList VALUES(109,0,0,101,15,1,1,0);
go
INSERT INTO GastroElementList VALUES(109,1,0,102,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,1,103,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,2,104,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,3,105,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,4,106,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,5,107,1.99,1,0,0);
go
INSERT INTO GastroElementList VALUES(109,1,6,108,1.99,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (112,0,0,16,15.5,1,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (112,0,1,27,5.99,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (112,0,2,25,1.6,3,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (112,0,3,30,3.5,1,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (112,0,4,19,2.2,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,0,0,103,8,2,1,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,1,0,103,4,1,1,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,1,1,104,3.5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,1,2,105,3,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,1,3,5,2.25,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (113,1,4,4,1.2,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,0,0,118,36,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,0,1,117,37,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,1,0,115,18,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,1,1,114,15,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,2,0,119,8,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,2,1,120,8,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,2,2,122,7,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,2,3,121,6,1,0,1);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,3,0,103,5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,3,1,104,5,1,0,0);
go
INSERT INTO GastroElementList (GastroSetProductId,Ordinal,ListOrdinal,ElementProductId,Price,Quantity,IsDefault,IsPriceFromProduct) VALUES (124,3,2,108,4,1,0,0);
go

/* GastroTransition */
INSERT INTO GastroTransition (VatRateId, ProductId, Type) VALUES (5,125,0);
go
INSERT INTO GastroTransition (VatRateId, ProductId, Type) VALUES (5,126,1);
go
INSERT INTO GastroTransition (VatRateId, ProductId, Type) VALUES (4,127,1);
go

/* CustomerCardFormat */
INSERT INTO CustomerCardFormat (CustomerCardFormatId, IsActive, Name, CodeLength, PrefixLength, PrefixPosition, YearLength, CustomerCodeLength, CustomerCodePosition, DatePosition, DiscountIdPosition, Prefix, IsExpireDate, IsMonth, IsControlDigit, IsAutoRecognize, ExternalId, Creation, LastUpdate) VALUES (1, 1, 'Karta rabatowa', 13, 3, 1, 2, 6, 6, 4, 12, '201', 1, 0, 1, 1, '', '2017-08-30 12:28:20.802', '2017-08-30 12:28:20.802');
go

/* DiscountDefined */
INSERT INTO DiscountDefined (DiscountDefinedId, IsActive, Type, Name, Purpose, DateFrom, DateTo, Days, Hours, DefaultValue, MaxValue, IsEditable, IsObligatory, IsPriceModify, RestrictionType, PurchaseValueFrom, PurchaseValueTo, ProductGroupId, Creation, LastUpdate, ExternalId) VALUES (1, 1, 1, 'Rabat 10%', 2, '2017-10-11 10:16:51.660', '2017-10-11 10:16:51.660', '', '', 10, 0, 0, 0, 0, 1, 0, 0, 0, '2017-10-11 10:17:26.463', '2017-10-11 10:17:54.820', '');
go
INSERT INTO DiscountDefined (DiscountDefinedId, IsActive, Type, Name, Purpose, DateFrom, DateTo, Days, Hours, DefaultValue, MaxValue, IsEditable, IsObligatory, IsPriceModify, RestrictionType, PurchaseValueFrom, PurchaseValueTo, ProductGroupId, Creation, LastUpdate, ExternalId) VALUES (2, 1, 1, 'Rabat na pozycję 5%', 1, '2017-10-11 10:17:28.799', '2017-10-11 10:17:28.799', '', '', 5, 0, 0, 0, 0, 1, 0, 0, 0, '2017-10-11 10:17:52.241', '2017-10-11 10:17:52.241', '');
go

/* RadDiscountDefinition */
/*
INSERT INTO RadDiscountDefinition (UniqueId,ProductCode,Name,DateStart,DateStop,LimitRemaining,DiscountType,DiscountValue,LastUpdate) VALUES ('1',5901559953760,'Skupuj żywca za pół ceny!','2018-01-01 00:00:00.000','2018-12-31 23:59:59.999',100,0,3.98,'2018-01-01 00:00:00.000');
go
INSERT INTO RadDiscountDefinition (UniqueId,ProductCode,Name,DateStart,DateStop,LimitRemaining,DiscountType,DiscountValue,LastUpdate) VALUES ('2',5901559830009,'Skupuj żywca za pół ceny!','2018-01-01 00:00:00.000','2018-01-15 23:59:59.999',100,0,5.59,'2018-01-01 00:00:00.000');
go
INSERT INTO RadDiscountDefinition (UniqueId,ProductCode,Name,DateStart,DateStop,LimitRemaining,DiscountType,DiscountValue,LastUpdate) VALUES ('3',5901559140009,'Skupuj żywca za pół ceny!','2018-01-16 00:00:00.000','2018-01-31 23:59:59.999',100,0,4.59,'2018-01-01 00:00:00.000');
go
*/


