# Odczytaj zalogowanego użytkownika
$currentLoggedInUser = $env:USERNAME

Write-Host "Skrypt doda noweg administratora i usunie z administratorow zalogowanego uzytkownika ($currentLoggedInUser)"
$confirmation = Read-Host "Kontynuowac? (T/N)"

# Normalizacja odpowiedzi użytkownika (ignorowanie wielkości liter)
switch ($confirmation.ToUpper()) {
    "T" { Write-Host "Kontynuuje skrypt..." }
    "N" { Write-Host "Skrypt zostal przerwany."; return }
    default { Write-Host "Niepoprawna odpowiedz. Skrypt zostal przerwany."; return }
}

$userLogin = Read-Host "Podaj nazwe konta administratora [myadmin]"
if ([string]::IsNullOrWhiteSpace($userLogin)) {
    $userLogin = "myadmin"
}
$userPassword = Read-Host -AsSecureString "Podaj haslo dla konta $userLogin"
New-LocalUser -Name $userLogin -Password $userPassword -FullName "Administrator $userLogin" -Description "Administrator komputera" -AccountNeverExpires

# SID dla grupy "Administrators"
$administratorsGroupSID = "S-1-5-32-544"
Add-LocalGroupMember -SID $administratorsGroupSID -Member $userLogin

# SID dla grupy "Users"
$usersGroupSID = "S-1-5-32-545"
Add-LocalGroupMember -SID $usersGroupSID -Member $currentLoggedInUser

# Usuń zalogowanego użytkownika z grupy "Administrators"
Remove-LocalGroupMember -SID $administratorsGroupSID -Member $currentLoggedInUser

# Wylogowanie użytkownika
shutdown /l
# Restart-Computer

