# Wyświetlenie tekstu
Write-Host "Skrypt doda użytkowników user i myadmin (z uprawnieniami administratora)"
Write-Host "Kontynować? T/N"

# Zapytanie o odpowiedź użytkownika
$odpowiedz = Read-Host

# Sprawdzanie odpowiedzi
if ($odpowiedz -eq "T" -or $odpowiedz -eq "t") {
    Write-Host "Kontynuuję skrypt..."
    # Tutaj umieść kod, który ma zostać wykonany, jeśli użytkownik wybierze T
} elseif ($odpowiedz -eq "N" -or $odpowiedz -eq "n") {
    Write-Host "Skrypt został przerwany."
    exit # Przerywa wykonanie skryptu
} else {
    Write-Host "Niepoprawna odpowiedź. Skrypt został przerwany."
    exit # Przerywa wykonanie skryptu, jeśli odpowiedź jest nieprawidłowa
}

$userPasswordInput = Read-Host -AsSecureString "Podaj hasło dla konta użytkownika (user)"
New-LocalUser -Name "user" -Password $userPasswordInput  -FullName "User" -Description "Standard user account" -AccountNeverExpires
Add-LocalGroupMember -Group "Administratorzy" -Member "user"

# Edycja rejestru - Usuń wartość LaunchUserOOBE w HKEY_LOCAL_MACHINE\SOFTWARE\Microsoft\Windows\CurrentVersion\OOBE
$regKeyOOBE = "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\OOBE"
if (Test-Path $regKeyOOBE) {
    Remove-ItemProperty -Path $regKeyOOBE -Name "LaunchUserOOBE" -ErrorAction SilentlyContinue
}

# Wyłączenie automatycznego logowania (w rejestrze)
$regKeyWinlogon = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon"
if (Test-Path $regKeyWinlogon) {
    Set-ItemProperty -Path $regKeyWinlogon -Name "AutoAdminLogon" -Value "0"
    Set-ItemProperty -Path $regKeyWinlogon -Name "AutoLogonSID" -Value ""
    Set-ItemProperty -Path $regKeyWinlogon -Name "DefaultUserName" -Value "User"
    Set-ItemProperty -Path $regKeyWinlogon -Name "DefaultPassword" -Value ""
    Set-ItemProperty -Path $regKeyWinlogon -Name "EnableFirstLogonAnimation" -Value 0
}

# Remove Windows Hello PIN registry key (this is risky, and it may not always work as intended)
$pinRegistryPath = "HKCU:\Software\Microsoft\Windows\CurrentVersion\Authentication\LogonUI"
Remove-ItemProperty -Path $pinRegistryPath -Name "LastUsedPin"
Write-Output "PIN settings have been cleared (if applicable). Please restart your computer."

Write-Host "Zmiany w rejestrze zostały zastosowane."

# Sprawdź, czy konto "DEFAULTUSER0" jest zalogowane
$defaultUser = Get-WmiObject -Class Win32_ComputerSystem
if ($defaultUser.UserName -eq "DEFAULTUSER0") {
    # Jeśli "DEFAULTUSER0" jest zalogowany, wyloguj go
    shutdown.exe /l
    Start-Sleep -Seconds 5  # Czekaj 5 sekund, aby proces wylogowania zakończył się
}

# Usuń konto "DEFAULTUSER0"
Remove-LocalUser -Name "DEFAULTUSER0"

Write-Host "Konta zostały utworzone, a konto DEFAULTUSER0 zostało usunięte."
Write-Host "Restartujemy komputer . . . . . ."
Sleep 1
Write-Host "Paaaaaa . . . . . ."
Restart-Computer

