# Skrypt PowerShell do odczytania i wyświetlenia klucza Windows

function Get-WindowsKey {
    try {
        # Ścieżka do rejestru, gdzie przechowywany jest klucz produktu
        $RegPath = "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion"
        $DigitalProductId = (Get-ItemProperty -Path $RegPath).DigitalProductId

        # Funkcja do dekodowania klucza produktu
        $Key = ''
        $Chars = 'BCDFGHJKMPQRTVWXY2346789'
        for ($i = 24; $i -ge 0; $i--) {
            $Current = 0
            for ($j = 14; $j -ge 0; $j--) {
                $Current = ($Current * 256) -bxor $DigitalProductId[$j + 52]
                $DigitalProductId[$j + 52] = [math]::Floor($Current / 24)
                $Current = $Current % 24
            }
            $Key = $Chars[$Current] + $Key
            if (($i % 5) -eq 0 -and $i -ne 0) {
                $Key = "-" + $Key
            }
        }

        Write-Output "Klucz Windows: $Key"
    } catch {
        Write-Error "Nie udało się odczytać klucza Windows. Upewnij się, że uruchamiasz skrypt jako administrator."
    }
}

# Wywołanie funkcji
Get-WindowsKey