﻿##
## Wlaczenie wykonywania skryptow

# Set-ExecutionPolicy RemoteSigned

#Requires -RunAsAdministrator
#Requires -Version 5.1

Clear-Host

Remove-Module -Name Sophia -Force -ErrorAction Ignore
Import-Module -Name C:\Serwis\Skrypty\ps\Sophia.psd1 -PassThru -Force

Import-LocalizedData -BindingVariable Global:Localization -FileName Sophia

# Checking
Check

# Create a restore point
CreateRestorePoint

### Disable Location tracking ###
### When Location Tracking is turned on, Windows and its apps are allowed to detect the current location of your computer or device. ###
### This can be used to pinpoint your exact location, e.g. Map traces the location of PC and helps you in exploring nearby restaurants.
If (!(Test-Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\CapabilityAccessManager\ConsentStore\location")) {
	New-Item -Path "HKLM:\SOFTWARE\Microsoft\Windows\CurrentVersion\CapabilityAccessManager\ConsentStore\location" -Force | Out-Null
}
New-ItemProperty -Path "HKLM:\Software\Microsoft\Windows\CurrentVersion\CapabilityAccessManager\ConsentStore\location" -Name "Value" -Type String -Value "Deny" -Force

### Disable Wi-Fi Sense ### 
### Wi-Fi Sense is a feature in Windows 10 that allows you to connect to your friends shared Wi-Fi connections. That is, you and your friends may opt to share your or their Wi-Fi connections. If your computer is logged into a Microsoft account, by default it will share your Wi-Fi password with your Skype, Outlook and Facebook friends, which means your Wi-Fi password will be sent to Microsoft. ###
### You should at least stop your PC from sending your Wi-Fi password.
New-ItemProperty -Path "HKLM:\SOFTWARE\Microsoft\WcmSvc\wifinetworkmanager\config" -Name "AutoConnectAllowedOEM" -Type DWord -Value 0 -Force

### Disable Windows Hello Biometrics ###
### Windows Hello biometrics lets you sign in to your devices, apps, online services, and networks using your face, iris, or fingerprint. With this Policy you can disable the Windows Hello Biometrics.
If (!(Test-Path "HKLM:\Software\Policies\Microsoft\Biometrics")) {
	New-Item -Path "HKLM:\Software\Policies\Microsoft\Biometrics" -Force | Out-Null
}
New-ItemProperty -Path "HKLM:\Software\Policies\Microsoft\Biometrics" -Name "Enabled" -Type DWord -Value 0 -Force

### Turn off help Microsoft improve typing and writing ### 
### When the Getting to know you privacy setting is turned on for inking & typing personalization in Windows 10, you can use your typing history and handwriting patterns to create a local user dictionary for you that is used to make better typing suggestions and improve handwriting recognition for each of the languages you use.
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\InputPersonalization" -Name "AllowInputPersonalization" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\InputPersonalization" -Name "RestrictImplicitInkCollection" -Type DWord -Value 1 -Force
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\InputPersonalization" -Name "RestrictImplicitTextCollection" -Type DWord -Value 1 -Force
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\HandwritingErrorReports" -Name "PreventHandwritingErrorReports" -Type DWord -Value 1 -Force
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\TabletPC" -Name "PreventHandwritingDataSharing" -Type DWord -Value 1 -Force

### Block suggestions and automatic Installation of apps ###
### Microsoft flushes various apps into the system without being asked, especially games such as Candy Crush Saga. Users have to uninstall these manually if they don't want them on their computer. ###
### To prevent these downloads from starting in the first place, a small intervention in the registry helps. Suggested apps pinned to Start are basically just advertising. This script will also disable suggested apps (ex: Candy Crush Soda Saga) for all accounts.
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "ContentDeliveryAllowed" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "OemPreInstalledAppsEnabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "PreInstalledAppsEnabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "PreInstalledAppsEverEnabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SilentInstalledAppsEnabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SubscribedContent-338387Enabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SubscribedContent-338388Enabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SubscribedContent-338389Enabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SubscribedContent-353698Enabled" -Type DWord -Value 0 -Force
New-ItemProperty -Path "HKCU:\SOFTWARE\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" -Name "SystemPaneSuggestionsEnabled" -Type DWord -Value 0 -Force
If (!(Test-Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent")) {
New-Item -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" -Force | Out-Null}
New-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" -Name "DisableWindowsConsumerFeatures" -Type DWord -Value 1 -Force

### Turn off distributing updates to other computers ###
### Windows 10 lets you download updates from several sources to speed up the process of updating the operating system. ###
### If you don't want your files to be shared by others and exposing your IP address to random computers, you can apply this policy and turn this feature off. ### 
### Acceptable selections include:
### Bypass (100) 
### Group (2)
### HTTP only (0) Enabled by SharpApp!
### LAN (1)
### Simple (99)
If (!(Test-Path "HKLM:\Software\Policies\Microsoft\Windows\DeliveryOptimization")) {
	New-Item -Path "HKLM:\Software\Policies\Microsoft\Windows\DeliveryOptimization" -Force | Out-Null
}
New-ItemProperty -Path "HKLM:\Software\Policies\Microsoft\Windows\DeliveryOptimization" -Name "DODownloadMode" -Type DWord -Value 0 -Force

#   Description:
# This script removes unwanted Apps that come with Windows. If you  do not want
# to remove certain Apps comment out the corresponding lines below.


Write-Output "Uninstalling default apps"
$apps = @(
    # default Windows 10 apps
    "Microsoft.3DBuilder"
    "Microsoft.Appconnector"
    "Microsoft.BingFinance"
    "Microsoft.BingNews"
    "Microsoft.BingSports"
    "Microsoft.BingTranslator"
    "Microsoft.GamingServices"
    "Microsoft.MicrosoftPowerBIForWindows"
    "Microsoft.MinecraftUWP"
    "Microsoft.NetworkSpeedTest"
    "Microsoft.Print3D"
    #"Microsoft.Windows.Photos"
    "Microsoft.WindowsPhone"
    "Microsoft.CommsPhone"
    "Microsoft.ConnectivityStore"
    "Microsoft.Messaging"
    "Microsoft.Office.Sway"
    "Microsoft.OneConnect"
    "Microsoft.BingFoodAndDrink"
    "Microsoft.BingHealthAndFitness"
    "Microsoft.BingTravel"
    "Microsoft.WindowsReadingList"

    # non-Microsoft
    "2FE3CB00.PicsArt-PhotoStudio"
    "46928bounde.EclipseManager"
    "4DF9E0F8.Netflix"
    "613EBCEA.PolarrPhotoEditorAcademicEdition"
    "6Wunderkinder.Wunderlist"
    "7EE7776C.LinkedInforWindows"
    "89006A2E.AutodeskSketchBook"
    "9E2F88E3.Twitter"
    "A278AB0D.DisneyMagicKingdoms"
    "A278AB0D.MarchofEmpires"
    "ActiproSoftwareLLC.562882FEEB491" # next one is for the Code Writer from Actipro Software LLC
    "CAF9E577.Plex"  
    "ClearChannelRadioDigital.iHeartRadio"
    "D52A8D61.FarmVille2CountryEscape"
    "D5EA27B7.Duolingo-LearnLanguagesforFree"
    "DB6EA5DB.CyberLinkMediaSuiteEssentials"
    "DolbyLaboratories.DolbyAccess"
    "DolbyLaboratories.DolbyAccess"
    "Drawboard.DrawboardPDF"
    "Facebook.Facebook"
    "Fitbit.FitbitCoach"
    "Flipboard.Flipboard"
    "GAMELOFTSA.Asphalt8Airborne"
    "KeeperSecurityInc.Keeper"
    "NORDCURRENT.COOKINGFEVER"
    "PandoraMediaInc.29680B314EFC2"
    "Playtika.CaesarsSlotsFreeCasino"
    "ShazamEntertainmentLtd.Shazam"
    "SlingTVLLC.SlingTV"
    "SpotifyAB.SpotifyMusic"
    "TheNewYorkTimes.NYTCrossword"
    "ThumbmunkeysLtd.PhototasticCollage"
    "TuneIn.TuneInRadio"
    "WinZipComputing.WinZipUniversal"
    "XINGAG.XING"
    "flaregamesGmbH.RoyalRevolt2"
    "king.com.*"
    "king.com.BubbleWitch3Saga"
    "king.com.CandyCrushSaga"
    "king.com.CandyCrushSodaSaga"
    
    "2FE3CB00.PicsArt-PhotoStudio"
    "828B5831.HiddenCityMysteryofShadows"
    "A278AB0D.MarchofEmpires"
    "AdobeSystemsIncorporated.AdobePhotoshopExpress"
    "AmazonVideo.PrimeVideo"
    "Microsoft.Todos"
    "Nordcurrent.CookingFever"
    "PLRWorldwideSales.FishdomPlayrix"
    "SpotifyAB.SpotifyMusic"
    "ROBLOXCorporation.ROBLOX"

    "Microsoft.Microsoft3DViewer"
    #"Microsoft.WindowsCalculator"
    #"Microsoft.WindowsStore"   # can't be re-installed

    "Microsoft.MSPaint"
    "Microsoft.MicrosoftOfficeHub"
    "Microsoft.MicrosoftSolitaireCollection"
    "Microsoft.MicrosoftStickyNotes"
    "Microsoft.Office.OneNote"
    "Microsoft.People"
    "Microsoft.SkypeApp"

    "Microsoft.WindowsAlarms"
    "Microsoft.WindowsCamera"
    "microsoft.windowscommunicationsapps"
    "Microsoft.WindowsMaps"
    "Microsoft.WindowsSoundRecorder"
    "Microsoft.Xbox.TCUI"
    "Microsoft.XboxApp"
    "Microsoft.XboxGameOverlay"
    "Microsoft.XboxSpeechToTextOverlay"
    "Microsoft.ZuneMusic"
    "Microsoft.ZuneVideo"
    "Microsoft.GetHelp"
    "Microsoft.Getstarted"
    "Microsoft.WindowsFeedbackHub"
    "Microsoft.MixedReality.Portal"
    "Microsoft.ScreenSketch"
    "Microsoft.Wallet"

    "Microsoft.Microsoft3DViewer"
    "Microsoft.XboxGamingOverlay"
    "Microsoft.YourPhone"
    "Microsoft.BingWeather"


    # apps which cannot be removed using Remove-AppxPackage
    #"Microsoft.BioEnrollment"
    #"Microsoft.MicrosoftEdge"
    #"Microsoft.Windows.Cortana"
    #"Microsoft.WindowsFeedback"
    #"Microsoft.XboxGameCallableUI"
    #"Microsoft.XboxIdentityProvider"
    #"Windows.ContactSupport"

    # apps which other apps depend on
    "Microsoft.Advertising.Xaml"
    
)

foreach ($app in $apps) {
    Write-Output "Trying to remove $app"

    Get-AppXProvisionedPackage -Online |
        Where-Object DisplayName -EQ $app |
        Remove-AppxProvisionedPackage -Online

    Get-AppxPackage -Name $app -AllUsers | Remove-AppxPackage -AllUsers
    Get-AppxPackage $app | Remove-AppxPackage -AllUsers
}


# Prevents Apps from re-installing
$cdm = @(
    "ContentDeliveryAllowed"
    "FeatureManagementEnabled"
    "OemPreInstalledAppsEnabled"
    "PreInstalledAppsEnabled"
    "PreInstalledAppsEverEnabled"
    "SilentInstalledAppsEnabled"
    "SubscribedContent-314559Enabled"
    "SubscribedContent-338387Enabled"
    "SubscribedContent-338388Enabled"
    "SubscribedContent-338389Enabled"
    "SubscribedContent-338393Enabled"
    "SubscribedContentEnabled"
    "SystemPaneSuggestionsEnabled"
)

New-FolderForced -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager"
foreach ($key in $cdm) {
    Set-ItemProperty -Path "HKCU:\Software\Microsoft\Windows\CurrentVersion\ContentDeliveryManager" $key 0
}

New-FolderForced -Path "HKLM:\SOFTWARE\Policies\Microsoft\WindowsStore"
Set-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\WindowsStore" "AutoDownload" 2

# Prevents "Suggested Applications" returning
New-FolderForced -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent"
Set-ItemProperty -Path "HKLM:\SOFTWARE\Policies\Microsoft\Windows\CloudContent" "DisableWindowsConsumerFeatures" 1

#   Description:
# This script disables unwanted Windows services. If you do not want to disable
# certain services comment out the corresponding lines below.

$services = @(
    "diagnosticshub.standardcollector.service" # Microsoft (R) Diagnostics Hub Standard Collector Service
    "DiagTrack"                                # Diagnostics Tracking Service
    "dmwappushservice"                         # WAP Push Message Routing Service (see known issues)
    "lfsvc"                                    # Geolocation Service
    "MapsBroker"                               # Downloaded Maps Manager
    "NetTcpPortSharing"                        # Net.Tcp Port Sharing Service
    "RemoteAccess"                             # Routing and Remote Access
    "RemoteRegistry"                           # Remote Registry
    "SharedAccess"                             # Internet Connection Sharing (ICS)
    "TrkWks"                                   # Distributed Link Tracking Client
    "WbioSrvc"                                 # Windows Biometric Service (required for Fingerprint reader / facial detection)
    "WlanSvc"                                 # WLAN AutoConfig
    "WMPNetworkSvc"                            # Windows Media Player Network Sharing Service
    #"wscsvc"                                  # Windows Security Center Service
    "WSearch"                                 # Windows Search
    "XblAuthManager"                           # Xbox Live Auth Manager
    "XblGameSave"                              # Xbox Live Game Save Service
    "XboxNetApiSvc"                            # Xbox Live Networking Service
    "ndu"                                      # Windows Network Data Usage Monitor
    # Services which cannot be disabled
    #"WdNisSvc"
)

foreach ($service in $services) {
    Write-Output "Trying to disable $service"
    Get-Service -Name $service | Set-Service -StartupType Disabled
}


## Funkcje Sophia

#region Privacy & Telemetry
# Disable the "Connected User Experiences and Telemetry" service
TelemetryService -Disable

# Set the OS level of diagnostic data gathering to minimum
DiagnosticDataLevel -Minimal

# Turn off Windows Error Reporting for the current user
ErrorReporting -Disable

# Change Windows feedback frequency to "Never" for the current user
WindowsFeedback -Disable

# Turn off diagnostics tracking scheduled tasks
ScheduledTasks -Disable

# Do not use sign-in info to automatically finish setting up device and reopen apps after an update or restart (current user only)
SigninInfo -Disable

# Do not let websites provide locally relevant content by accessing language list (current user only)
LanguageListAccess -Disable

# Do not allow apps to use advertising ID (current user only)
AdvertisingID -Disable

# Do not let apps on other devices open and message apps on this device, and vice versa (current user only)
ShareAcrossDevices -Disable

# Hide the Windows welcome experiences after updates and occasionally when I sign in to highlight what's new and suggested (current user only)
WindowsWelcomeExperience -Hide

# Do not get tip, trick, and suggestions as you use Windows (current user only)
WindowsTips -Disable

# Hide suggested content in the Settings app (current user only)
SettingsSuggestedContent -Hide

# Turn off automatic installing suggested apps (current user only)
AppsSilentInstalling -Disable

# Do not suggest ways I can finish setting up my device to get the most out of Windows (current user only)
WhatsNewInWindows -Disable

# Do not offer tailored experiences based on the diagnostic data setting (current user only)
TailoredExperiences -Disable

# Disable Bing search in the Start Menu
BingSearch -Disable

#endregion Privacy & Telemetry

#region UI & Personalization
# Show "This PC" on Desktop (current user only)
ThisPC -Show

# Do not use check boxes to select items (current user only)
CheckBoxes -Disable

# Show hidden files, folders, and drives (current user only)
HiddenItems -Enable

# Do not show hidden files, folders, and drives (current user only) (default value)
# HiddenItems -Disable

# Show file name extensions (current user only)
FileExtensions -Show

# Hide file name extensions (current user only) (default value)
# FileExtensions -Hide

# Do not hide folder merge conflicts (current user only)
MergeConflicts -Show

# Hide folder merge conflicts (current user only) (default value)
# MergeConflicts -Hide

# Open File Explorer to: "This PC" (current user only)
OpenFileExplorerTo -ThisPC

# Open File Explorer to: "Quick access" (current user only) (default value)
# OpenFileExplorerTo -QuickAccess

# Hide Cortana button on the taskbar (current user only)
CortanaButton -Hide

# Do not show sync provider notification within File Explorer (current user only)
OneDriveFileExplorerAd -Hide

# Hide Task View button on the taskbar (current user only)
TaskViewButton -Hide

# Hide People button on the taskbar (current user only)
PeopleTaskbar -Hide

# When I snap a window, do not show what I can snap next to it (current user only)
SnapAssist -Disable

# When I snap a window, show what I can snap next to it (current user only) (default value)
# SnapAssist -Enable

# Always open the file transfer dialog box in the detailed mode (current user only)
FileTransferDialog -Detailed

# Always open the file transfer dialog box in the compact mode (current user only) (default value)
# FileTransferDialog -Compact

# Always expand the ribbon in the File Explorer (current user only)
FileExplorerRibbon -Expanded

# Always minimize the ribbon in the File Explorer (current user only) (default value)
# FileExplorerRibbon -Minimized

# Display recycle bin files delete confirmation
RecycleBinDeleteConfirmation -Enable

# Do not display recycle bin files delete confirmation (default value)
# RecycleBinDeleteConfirmation -Disable

# Hide the "3D Objects" folder in "This PC" and "Quick access" (current user only)
3DObjects -Hide

# Show the "3D Objects" folder in "This PC" and "Quick access" (current user only) (default value)
# 3DObjects -Show

# Hide frequently used folders in "Quick access" (current user only)
QuickAccessFrequentFolders -Hide

# Show frequently used folders in "Quick access" (current user only) (default value)
# QuickAccessFrequentFolders -Show

# Do not show recently used files in Quick access (current user only)
QuickAccessRecentFiles -Hide

# Show recently used files in Quick access (current user only) (default value)
# QuickAccessRecentFiles -Show

# Hide the search box or the search icon from the taskbar (current user only)
TaskbarSearch -Hide

# Do not show the "Windows Ink Workspace" button on the taskbar (current user only)
WindowsInkWorkspace -Hide

# Always show all icons in the notification area (current user only)
TrayIcons -Show

# Unpin "Microsoft Edge" and "Microsoft Store" from the taskbar (current user only)
UnpinTaskbarEdgeStore

# View the Control Panel icons by: large icons (current user only)
ControlPanelView -LargeIcons

# View the Control Panel icons by: category (current user only) (default value)
# ControlPanelView -Category

# Set the Windows mode color scheme to the dark (current user only)
# WindowsColorScheme -Dark
# WindowsColorScheme -Light
# AppMode -Dark
# AppMode -Light

# Do not show the "New App Installed" indicator
NewAppInstalledNotification -Hide

# Hide user first sign-in animation after the upgrade
FirstLogonAnimation -Disable

# Set the quality factor of the JPEG desktop wallpapers to maximum (current user only)
JPEGWallpapersQuality -Max

# Set the quality factor of the JPEG desktop wallpapers to default (current user only)
# JPEGWallpapersQuality -Default

# Start Task Manager in expanded mode (current user only)
TaskManagerWindow -Expanded

# Show a notification when your PC requires a restart to finish updating
RestartNotification -Show

# Do not show a notification when your PC requires a restart to finish updating (default value)
# RestartNotification -Hide

# Do not add the "- Shortcut" suffix to the file name of created shortcuts (current user only)
ShortcutsSuffix -Disable

# Add the "- Shortcut" suffix to the file name of created shortcuts (current user only) (default value)
# ShortcutsSuffix -Enable

# Use the PrtScn button to open screen snipping (current user only)
# PrtScnSnippingTool -Enable

# Do not use the PrtScn button to open screen snipping (current user only) (default value)
# PrtScnSnippingTool -Disable
#endregion UI & Personalization

#region OneDrive
# Uninstall OneDrive
UninstallOneDrive
#endregion OneDrive

#region System
#region StorageSense
# Turn on Storage Sense (current user only)
StorageSense -Enable

# Turn off Storage Sense (current user only) (default value)
# StorageSense -Disable

# Run Storage Sense every month (current user only)
StorageSenseFrequency -Month

# Delete temporary files that apps aren't using (current user only)
StorageSenseTempFiles -Enable

# Do not delete temporary files that apps aren't using (current user only)
# StorageSenseTempFiles -Disable

# Delete files in recycle bin if they have been there for over 30 days (current user only)
StorageSenseRecycleBin -Enable

# Do not delete files in recycle bin if they have been there for over 30 days (current user only)
# StorageSenseRecycleBin -Disable
#endregion StorageSense

# Disable hibernation if the device is not a laptop
Hibernate -Disable

# Change the %TEMP% environment variable path to the %SystemDrive%\Temp (both machine-wide, and for the current user)
TempPath -SystemDrive

# Change %TEMP% environment variable path to the %LOCALAPPDATA%\Temp (both machine-wide, and for the current user) (default value)
# TempPath -Default

# Disable Windows 260 character path limit
Win32LongPathLimit -Disable

# Display the Stop error information on the BSoD
BSoDStopError -Enable

# Do not display the Stop error information on the BSoD (default value)
# BSoDStopError -Disable

# Change "Behavior of the elevation prompt for administrators in Admin Approval Mode" to "Elevate without prompting"
AdminApprovalMode -Disable

# Turn on access to mapped drives from app running with elevated permissions with Admin Approval Mode enabled
MappedDrivesAppElevatedAccess -Enable

# Turn off access to mapped drives from app running with elevated permissions with Admin Approval Mode enabled (default value)
# MappedDrivesAppElevatedAccess -Disable

# Opt out of the Delivery Optimization-assisted updates downloading
DeliveryOptimization -Disable

# Always wait for the network at computer startup and logon for workgroup networks
WaitNetworkStartup -Enable

# Do not let Windows decide which printer should be the default one (current user only)
WindowsManageDefaultPrinter -Disable

# Let Windows decide which printer should be the default one (current user only) (default value)
# WindowsManageDefaultPrinter -Enable

# Disable the following Windows features
WindowsFeatures -Disable

# Enable Windows features (default value)
# WindowsFeatures -Enable

# Disable Feature On Demand v2 (FODv2) capabilities using the pop-up dialog box
DisableWindowsCapabilities

# Opt-in to Microsoft Update service, so to receive updates for other Microsoft products
UpdateMicrosoftProducts -Enable

# Do not let UWP apps run in the background except some (current user only)
BackgroundUWPApps -Disable

# Set the power management scheme on "High performance" if device is a desktop
PowerManagementScheme -High

# Set the power management scheme on "Balanced" (default value)
# PowerManagementScheme -Balanced

# Use latest installed .NET runtime for all apps
LatestInstalled.NET -Enable

# Do not use latest installed .NET runtime for all apps (default value)
# LatestInstalled.NET -Disable

# Do not allow the computer (if device is not a laptop) to turn off the network adapters to save power
PCTurnOffDevice -Disable

# Set the default input method to the English language
# SetInputMethod -English

# Reset the default input method
# SetInputMethod -Default

# Save screenshots by pressing Win+PrtScr to the Pictures folder (current user only) (default value)
# WinPrtScrFolder -Default

# Launch folder windows in a separate process (current user only)
FoldersLaunchSeparateProcess -Enable

# Disable and delete reserved storage after the next update installation
ReservedStorage -Disable

# Enable reserved storage (default value)
# ReservedStorage -Enable

# Disable help lookup via F1 (current user only)
F1HelpPage -Disable

# Enable help lookup via F1 (current user only) (default value)
# F1HelpPage -Enable

# Enable Num Lock at startup
NumLock -Enable

# Disable Num Lock at startup (default value)
# NumLock -Disable

# Disable StickyKey after tapping the Shift key 5 times (current user only)
StickyShift -Disable

# Disable AutoPlay for all media and devices (current user only)
Autoplay -Disable

# Disable thumbnail cache removal
# ThumbnailCacheRemoval -Disable

# Enable thumbnail cache removal (default value)
# ThumbnailCacheRemoval -Enable

# Enable automatically saving my restartable apps when signing out and restart them after signing in (current user only)
SaveRestartableApps -Enable

# Disable automatically saving my restartable apps when signing out and restart them after signing in (current user only) (default value)
# SaveRestartableApps -Disable

# Enable "Network Discovery" and "File and Printers Sharing" for workgroup networks
# NetworkDiscovery -Enable

# Disable "Network Discovery" and "File and Printers Sharing" for workgroup networks (default value)
# NetworkDiscovery -Disable

# Automatically adjust active hours for me based on daily usage
SmartActiveHours -Enable

# Do not automatically adjust active hours for me based on daily usage (default value)
# SmartActiveHours -Disable

# Enable restarting this device as soon as possible when a restart is required to install an update
# DeviceRestartAfterUpdate -Enable

# Disable restarting this device as soon as possible when a restart is required to install an update (default value)
# DeviceRestartAfterUpdate -Disable
#endregion System

#region Start menu
# Hide recently added apps in the Start menu
RecentlyAddedApps -Hide

# Hide app suggestions in the Start menu
AppSuggestions -Hide

# Run the Command Prompt shortcut from the Start menu as Administrator
RunCMDShortcut -Elevated

# Unpin all the Start tiles
UnpinAllStartTiles

<#
	Test if syspin.exe is in a folder. Unless download it
	Проверить, находится ли файл syspin.exe в папке. Иначе скачать его

	http://www.technosys.net/products/utils/pintotaskbar
	SHA256: 6967E7A3C2251812DD6B3FA0265FB7B61AADC568F562A98C50C345908C6E827
#>
syspin

# Pin the "Control Panel" shortcut to Start within syspin
PinControlPanel

# Pin the old-style "Devices and Printers" shortcut to Start within syspin
PinDevicesPrinters

# Pin the Command Prompt" shortcut to Start within syspin
PinCommandPrompt
#endregion Start menu

#region UWP apps
<#
	Uninstall UWP apps using the pop-up dialog box that enables the user to select packages to remove
	App packages will not be installed for new users if "Uninstall for All Users" is checked

	Удалить UWP-приложения, используя всплывающее диалоговое окно, позволяющее пользователю отметить пакеты на удаление
	Приложения не будут установлены для новых пользователе, если отмечено "Удалять для всех пользователей"
#>
# UninstallUWPApps

<#
	Open Microsoft Store "HEVC Video Extensions from Device Manufacturer" page
	The extension can be installed without Microsoft account for free instead of $0.99
	"Movies & TV" app required

	Открыть страницу "Расширения для видео HEVC от производителя устройства" в Microsoft Store
	Расширение может быть установлено бесплатно без учетной записи Microsoft вместо 0,99 $
	Для работы необходимо приложение "Кино и ТВ"
#>
InstallHEVC

# Disable Cortana autostarting
CortanaAutostart -Disable

# Check for UWP apps updates
CheckUWPAppsUpdates
#endregion UWP apps

#region Gaming
# Disable Xbox Game Bar
XboxGameBar -Disable
XboxGameTips -Disable
<#
	Set "High performance" in graphics performance preference for an app
	Only with a dedicated GPU

	Установить параметры производительности графики для отдельных приложений на "Высокая производительность"
	Только при наличии внешней видеокарты
#>
SetAppGraphicsPerformance

<#
	Turn on hardware-accelerated GPU scheduling. Restart needed
	Only with a dedicated GPU and WDDM verion is 2.7 or higher

	Включить планирование графического процессора с аппаратным ускорением. Необходима перезагрузка
	Только при наличии внешней видеокарты и WDDM версии 2.7 и выше
#>
GPUScheduling -Enable

# Turn off hardware-accelerated GPU scheduling (default value). Restart needed
# GPUScheduling -Disable
#endregion Gaming

#region Scheduled tasks
<#
	Create a task to clean up unused files and Windows updates in the Task Scheduler
	A minute before the task starts, a warning in the Windows action center will appear
	The task runs every 90 days

#>
CreateCleanUpTask

# Delete a task to clean up unused files and Windows updates in the Task Scheduler
# DeleteCleanUpTask

<#
	Create a task to clear the %SystemRoot%\SoftwareDistribution\Download folder in the Task Scheduler
	The task runs on Thursdays every 4 weeks
#>
CreateSoftwareDistributionTask

# Delete a task to clear the %SystemRoot%\SoftwareDistribution\Download folder in the Task Scheduler
# DeleteSoftwareDistributionTask

<#
	Create a task to clear the %TEMP% folder in the Task Scheduler
	The task runs every 62 days
#>
CreateTempTask

# Delete a task to clear the %TEMP% folder in the Task Scheduler
# DeleteTempTask
#endregion Scheduled tasks

#region Microsoft Defender & Security

# Enable Microsoft Defender Exploit Guard network protection
NetworkProtection -Enable

# Disable Microsoft Defender Exploit Guard network protection (default value)
# NetworkProtection -Disable

# Enable detection for potentially unwanted applications and block them
PUAppsDetection -Enable

# Disable detection for potentially unwanted applications and block them (default value)
# PUAppsDetection -Disable

# Enable sandboxing for Microsoft Defender
DefenderSandbox -Enable

# Disable sandboxing for Microsoft Defender (default value)
# DefenderSandbox -Disable

# Dismiss Microsoft Defender offer in the Windows Security about signing in Microsoft account
DismissMSAccount

# Dismiss Microsoft Defender offer in the Windows Security about turning on the SmartScreen filter for Microsoft Edge
DismissSmartScreenFilter

# Enable events auditing generated when a process is created or starts
AuditProcess -Enable

# Disable events auditing generated when a process is created or starts (default value)
# AuditProcess -Disable

<#
	Include command line in process creation events
	In order this feature to work events auditing must be enabled ("AuditProcess" function)

	Включать командную строку в событиях создания процесса
	Необходимо включить аудит событий, чтобы работала данная опция (функция "AuditProcess")
#>
AuditCommandLineProcess -Enable

# Do not include command line in process creation events (default value)
# AuditCommandLineProcess -Disable

<#
	Create "Process Creation" Event Viewer Custom View
	In order this feature to work events auditing and command line in process creation events must be enabled ("EnableAuditProcess" function)

	Создать настаиваемое представление "Создание процесса" в Просмотре событий
	Необходимо включить аудит событий и командной строки в событиях создания процесса, чтобы работал данный функционал (функция "EnableAuditProcess")
#>
EventViewerCustomView -Enable

# Remove "Process Creation" Event Viewer Custom View (default value)
# EventViewerCustomView -Disable

# Enable logging for all Windows PowerShell modules
PowerShellModulesLogging -Enable

# Disable logging for all Windows PowerShell modules (default value)
# PowerShellModulesLogging -Disable

# Enable logging for all PowerShell scripts input to the Windows PowerShell event log
PowerShellScriptsLogging -Enable

# Disable logging for all PowerShell scripts input to the Windows PowerShell event log (default value)
# PowerShellScriptsLogging -Disable

# Disable apps and files checking within Microsofot Defender SmartScreen
AppsSmartScreen -Disable

# Enable apps and files checking within Microsofot Defender SmartScree (default value)
# AppsSmartScreen -Enable

# Disable the Attachment Manager marking files that have been downloaded from the Internet as unsafe (current user only)
SaveZoneInformation -Disable

# Enable the Attachment Manager marking files that have been downloaded from the Internet as unsafe (current user only) (default value)
# SaveZoneInformation -Enable

<#
	Disable Windows Script Host (current user only)
	It becomes impossible to run .js and .vbs files

	Отключить Windows Script Host (только для текущего пользователя)
	Становится невозможным запустить файлы .js и .vbs
#>
WindowsScriptHost -Disable

# Emable Windows Script Host (current user only) (default value)
# WindowsScriptHost -Enable

# Enable Windows Sandbox
# Включить Windows Sandbox
# WindowsSandbox -Enable

# Disable Windows Sandbox (default value)
# Выключить Windows Sandbox (значение по умолчанию)
# WindowsSandbox -Disable
#endregion Microsoft Defender & Security

#region Context menu

# Hide the "Share" item from the context menu
ShareContext -Hide

# Hide the "Edit with Paint 3D" item from the context menu
EditWithPaint3DContext -Hide

# Hide the "Edit with Photos" item from the context menu
EditWithPhotosContext -Hide

# Hide the "Create a new video" item from the context menu
CreateANewVideoContext -Hide

# Hide the "Edit" item from the images context menu
ImagesEditContext -Hide

# Hide the "Print" item from the .bat and .cmd context menu
PrintCMDContext -Hide

# Hide the "Include in Library" item from the context menu
IncludeInLibraryContext -Hide

# Hide the "Turn on BitLocker" item from the context menu
BitLockerContext -Hide

# Remove the "Bitmap image" item from the "New" context menu
BitmapImageNewContext -Remove

# Remove the "Rich Text Document" item from the "New" context menu
RichTextDocumentNewContext -Remove

# Hide the "Look for an app in the Microsoft Store" item in the "Open with" dialog
UseStoreOpenWith -Hide

# Hide the "Previous Versions" tab from files and folders context menu and also the "Restore previous versions" context menu item
PreviousVersionsPage -Hide

# Show the "Previous Versions" tab from files and folders context menu and also the "Restore previous versions" context menu item (default value)
# PreviousVersionsPage -Show
#endregion Context menu

<#
	Simulate pressing F5 to refresh the desktop
	Refresh desktop icons, environment variables, taskbar
	Restart the Start menu
#>
Refresh

# Errors output
Errors




