@echo off
echo ----------------------------------------------------
echo Skrypt do wykonywania kopii bezpieczeństwa bazy MSSQL
echo Autor: Mieszko Urbanowski @ PAJ-COMP
echo wersja: 20210817
echo ----------------------------------------------------


: Serwer SQL
SET SQLSRV=127.0.0.1,52014

: lista baz do archwizacji
: BAZY=baza1 baza2 baza3
SET BAZY=pcmarket szkolenie

: katalog gdzie zostanie zapisana kopia
SET TARGET=C:\Serwis\Kopia_bazy\

SET HH=%time:~0,2%
SET MM=%time:~3,2%
SET SS=%time:~6,2%

SET DZIEN=%date:~0,2%
SET MIESIAC=%date:~3,2%
SET ROK=%date:~6,4%

SET TOKEN=%ROK%%MIESIAC%%DZIEN%_%HH%%MM%%SS%
: SET /A TOKEN=%DZIEN% %% 7
SET FILE=Kopia_%TOKEN%

mkdir %TARGET%

echo Archiwizacja BAZY, prosze czekac
echo %date% %time% - START SQL %0 >> %0.log

(for %%b in (%BAZY%) do (
echo %date% %time% - Start %%b >> %0.log
sqlcmd -S%SQLSRV% -E -Q "backup database [%%b] TO DISK=N'%TARGET%%FILE%_%%b.bak' with name=N'Kopia %%b %date% %time%', SKIP, STATS = 5, NOFORMAT"
echo %date% %time% - Koniec %%b >> %0.log
))
echo %date% %time% - KONIEC SQL %0 >> %0.log
start %TARGET%
