/*
 * Decompiled with CFR 0.152.
 */
package java.time.temporal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.Chronology;
import java.time.format.ResolverStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.ValueRange;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

public final class WeekFields
implements Serializable {
    private static final ConcurrentMap<String, WeekFields> CACHE = new ConcurrentHashMap<String, WeekFields>(4, 0.75f, 2);
    public static final WeekFields ISO = new WeekFields(DayOfWeek.MONDAY, 4);
    public static final WeekFields SUNDAY_START = WeekFields.of(DayOfWeek.SUNDAY, 1);
    public static final TemporalUnit WEEK_BASED_YEARS = IsoFields.WEEK_BASED_YEARS;
    private static final long serialVersionUID = -1177360819670808121L;
    private final DayOfWeek firstDayOfWeek;
    private final int minimalDays;
    private final transient TemporalField dayOfWeek = ComputedDayOfField.ofDayOfWeekField(this);
    private final transient TemporalField weekOfMonth = ComputedDayOfField.ofWeekOfMonthField(this);
    private final transient TemporalField weekOfYear = ComputedDayOfField.ofWeekOfYearField(this);
    private final transient TemporalField weekOfWeekBasedYear = ComputedDayOfField.ofWeekOfWeekBasedYearField(this);
    private final transient TemporalField weekBasedYear = ComputedDayOfField.ofWeekBasedYearField(this);

    public static WeekFields of(Locale locale) {
        Objects.requireNonNull(locale, "locale");
        locale = new Locale(locale.getLanguage(), locale.getCountry());
        int n = CalendarDataUtility.retrieveFirstDayOfWeek(locale);
        DayOfWeek dayOfWeek = DayOfWeek.SUNDAY.plus(n - 1);
        int n2 = CalendarDataUtility.retrieveMinimalDaysInFirstWeek(locale);
        return WeekFields.of(dayOfWeek, n2);
    }

    public static WeekFields of(DayOfWeek dayOfWeek, int n) {
        String string = dayOfWeek.toString() + n;
        WeekFields weekFields = (WeekFields)CACHE.get(string);
        if (weekFields == null) {
            weekFields = new WeekFields(dayOfWeek, n);
            CACHE.putIfAbsent(string, weekFields);
            weekFields = (WeekFields)CACHE.get(string);
        }
        return weekFields;
    }

    private WeekFields(DayOfWeek dayOfWeek, int n) {
        Objects.requireNonNull(dayOfWeek, "firstDayOfWeek");
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Minimal number of days is invalid");
        }
        this.firstDayOfWeek = dayOfWeek;
        this.minimalDays = n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, InvalidObjectException {
        objectInputStream.defaultReadObject();
        if (this.firstDayOfWeek == null) {
            throw new InvalidObjectException("firstDayOfWeek is null");
        }
        if (this.minimalDays < 1 || this.minimalDays > 7) {
            throw new InvalidObjectException("Minimal number of days is invalid");
        }
    }

    private Object readResolve() throws InvalidObjectException {
        try {
            return WeekFields.of(this.firstDayOfWeek, this.minimalDays);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidObjectException("Invalid serialized WeekFields: " + illegalArgumentException.getMessage());
        }
    }

    public DayOfWeek getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDays;
    }

    public TemporalField dayOfWeek() {
        return this.dayOfWeek;
    }

    public TemporalField weekOfMonth() {
        return this.weekOfMonth;
    }

    public TemporalField weekOfYear() {
        return this.weekOfYear;
    }

    public TemporalField weekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public TemporalField weekBasedYear() {
        return this.weekBasedYear;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekFields) {
            return this.hashCode() == object.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.firstDayOfWeek.ordinal() * 7 + this.minimalDays;
    }

    public String toString() {
        return "WeekFields[" + this.firstDayOfWeek + ',' + this.minimalDays + ']';
    }

    static class ComputedDayOfField
    implements TemporalField {
        private final String name;
        private final WeekFields weekDef;
        private final TemporalUnit baseUnit;
        private final TemporalUnit rangeUnit;
        private final ValueRange range;
        private static final ValueRange DAY_OF_WEEK_RANGE = ValueRange.of(1L, 7L);
        private static final ValueRange WEEK_OF_MONTH_RANGE = ValueRange.of(0L, 1L, 4L, 6L);
        private static final ValueRange WEEK_OF_YEAR_RANGE = ValueRange.of(0L, 1L, 52L, 54L);
        private static final ValueRange WEEK_OF_WEEK_BASED_YEAR_RANGE = ValueRange.of(1L, 52L, 53L);

        static ComputedDayOfField ofDayOfWeekField(WeekFields weekFields) {
            return new ComputedDayOfField("DayOfWeek", weekFields, ChronoUnit.DAYS, ChronoUnit.WEEKS, DAY_OF_WEEK_RANGE);
        }

        static ComputedDayOfField ofWeekOfMonthField(WeekFields weekFields) {
            return new ComputedDayOfField("WeekOfMonth", weekFields, ChronoUnit.WEEKS, ChronoUnit.MONTHS, WEEK_OF_MONTH_RANGE);
        }

        static ComputedDayOfField ofWeekOfYearField(WeekFields weekFields) {
            return new ComputedDayOfField("WeekOfYear", weekFields, ChronoUnit.WEEKS, ChronoUnit.YEARS, WEEK_OF_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekOfWeekBasedYearField(WeekFields weekFields) {
            return new ComputedDayOfField("WeekOfWeekBasedYear", weekFields, ChronoUnit.WEEKS, IsoFields.WEEK_BASED_YEARS, WEEK_OF_WEEK_BASED_YEAR_RANGE);
        }

        static ComputedDayOfField ofWeekBasedYearField(WeekFields weekFields) {
            return new ComputedDayOfField("WeekBasedYear", weekFields, IsoFields.WEEK_BASED_YEARS, ChronoUnit.FOREVER, ChronoField.YEAR.range());
        }

        private ChronoLocalDate ofWeekBasedYear(Chronology chronology, int n, int n2, int n3) {
            ChronoLocalDate chronoLocalDate = chronology.date(n, 1, 1);
            int n4 = this.localizedDayOfWeek(chronoLocalDate);
            int n5 = this.startOfWeekOffset(1, n4);
            int n6 = chronoLocalDate.lengthOfYear();
            int n7 = this.computeWeek(n5, n6 + this.weekDef.getMinimalDaysInFirstWeek());
            n2 = Math.min(n2, n7 - 1);
            int n8 = -n5 + (n3 - 1) + (n2 - 1) * 7;
            return chronoLocalDate.plus(n8, ChronoUnit.DAYS);
        }

        private ComputedDayOfField(String string, WeekFields weekFields, TemporalUnit temporalUnit, TemporalUnit temporalUnit2, ValueRange valueRange) {
            this.name = string;
            this.weekDef = weekFields;
            this.baseUnit = temporalUnit;
            this.rangeUnit = temporalUnit2;
            this.range = valueRange;
        }

        @Override
        public long getFrom(TemporalAccessor temporalAccessor) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.localizedDayOfWeek(temporalAccessor);
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                return this.localizedWeekOfMonth(temporalAccessor);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return this.localizedWeekOfYear(temporalAccessor);
            }
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                return this.localizedWeekOfWeekBasedYear(temporalAccessor);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return this.localizedWeekBasedYear(temporalAccessor);
            }
            throw new IllegalStateException("unreachable, rangeUnit: " + this.rangeUnit + ", this: " + this);
        }

        private int localizedDayOfWeek(TemporalAccessor temporalAccessor) {
            int n = this.weekDef.getFirstDayOfWeek().getValue();
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_WEEK);
            return Math.floorMod(n2 - n, 7) + 1;
        }

        private int localizedDayOfWeek(int n) {
            int n2 = this.weekDef.getFirstDayOfWeek().getValue();
            return Math.floorMod(n - n2, 7) + 1;
        }

        private long localizedWeekOfMonth(TemporalAccessor temporalAccessor) {
            int n = this.localizedDayOfWeek(temporalAccessor);
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_MONTH);
            int n3 = this.startOfWeekOffset(n2, n);
            return this.computeWeek(n3, n2);
        }

        private long localizedWeekOfYear(TemporalAccessor temporalAccessor) {
            int n = this.localizedDayOfWeek(temporalAccessor);
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            int n3 = this.startOfWeekOffset(n2, n);
            return this.computeWeek(n3, n2);
        }

        private int localizedWeekBasedYear(TemporalAccessor temporalAccessor) {
            int n = this.localizedDayOfWeek(temporalAccessor);
            int n2 = temporalAccessor.get(ChronoField.YEAR);
            int n3 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            int n4 = this.startOfWeekOffset(n3, n);
            int n5 = this.computeWeek(n4, n3);
            if (n5 == 0) {
                return n2 - 1;
            }
            ValueRange valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR);
            int n6 = (int)valueRange.getMaximum();
            int n7 = this.computeWeek(n4, n6 + this.weekDef.getMinimalDaysInFirstWeek());
            if (n5 >= n7) {
                return n2 + 1;
            }
            return n2;
        }

        private int localizedWeekOfWeekBasedYear(TemporalAccessor temporalAccessor) {
            ValueRange valueRange;
            int n;
            int n2;
            int n3 = this.localizedDayOfWeek(temporalAccessor);
            int n4 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            int n5 = this.startOfWeekOffset(n4, n3);
            int n6 = this.computeWeek(n5, n4);
            if (n6 == 0) {
                ChronoLocalDate chronoLocalDate = Chronology.from(temporalAccessor).date(temporalAccessor);
                chronoLocalDate = chronoLocalDate.minus(n4, ChronoUnit.DAYS);
                return this.localizedWeekOfWeekBasedYear(chronoLocalDate);
            }
            if (n6 > 50 && n6 >= (n2 = this.computeWeek(n5, (n = (int)(valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR)).getMaximum()) + this.weekDef.getMinimalDaysInFirstWeek()))) {
                n6 = n6 - n2 + 1;
            }
            return n6;
        }

        private int startOfWeekOffset(int n, int n2) {
            int n3 = Math.floorMod(n - n2, 7);
            int n4 = -n3;
            if (n3 + 1 > this.weekDef.getMinimalDaysInFirstWeek()) {
                n4 = 7 - n3;
            }
            return n4;
        }

        private int computeWeek(int n, int n2) {
            return (7 + n + (n2 - 1)) / 7;
        }

        @Override
        public <R extends Temporal> R adjustInto(R r, long l) {
            int n;
            int n2 = this.range.checkValidIntValue(l, this);
            if (n2 == (n = r.get(this))) {
                return r;
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                int n3 = r.get(this.weekDef.dayOfWeek);
                int n4 = r.get(this.weekDef.weekOfWeekBasedYear);
                return (R)this.ofWeekBasedYear(Chronology.from(r), (int)l, n4, n3);
            }
            return (R)r.plus(n2 - n, this.baseUnit);
        }

        @Override
        public ChronoLocalDate resolve(Map<TemporalField, Long> map, TemporalAccessor temporalAccessor, ResolverStyle resolverStyle) {
            long l = map.get(this);
            int n = Math.toIntExact(l);
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                int n2 = this.range.checkValidIntValue(l, this);
                int n3 = this.weekDef.getFirstDayOfWeek().getValue();
                long l2 = Math.floorMod(n3 - 1 + (n2 - 1), 7) + 1;
                map.remove(this);
                map.put(ChronoField.DAY_OF_WEEK, l2);
                return null;
            }
            if (!map.containsKey(ChronoField.DAY_OF_WEEK)) {
                return null;
            }
            int n4 = ChronoField.DAY_OF_WEEK.checkValidIntValue(map.get(ChronoField.DAY_OF_WEEK));
            int n5 = this.localizedDayOfWeek(n4);
            Chronology chronology = Chronology.from(temporalAccessor);
            if (map.containsKey(ChronoField.YEAR)) {
                int n6 = ChronoField.YEAR.checkValidIntValue(map.get(ChronoField.YEAR));
                if (this.rangeUnit == ChronoUnit.MONTHS && map.containsKey(ChronoField.MONTH_OF_YEAR)) {
                    long l3 = map.get(ChronoField.MONTH_OF_YEAR);
                    return this.resolveWoM(map, chronology, n6, l3, n, n5, resolverStyle);
                }
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    return this.resolveWoY(map, chronology, n6, n, n5, resolverStyle);
                }
            } else if ((this.rangeUnit == WEEK_BASED_YEARS || this.rangeUnit == ChronoUnit.FOREVER) && map.containsKey(this.weekDef.weekBasedYear) && map.containsKey(this.weekDef.weekOfWeekBasedYear)) {
                return this.resolveWBY(map, chronology, n5, resolverStyle);
            }
            return null;
        }

        private ChronoLocalDate resolveWoM(Map<TemporalField, Long> map, Chronology chronology, int n, long l, long l2, int n2, ResolverStyle resolverStyle) {
            ChronoLocalDate chronoLocalDate;
            if (resolverStyle == ResolverStyle.LENIENT) {
                chronoLocalDate = chronology.date(n, 1, 1).plus(Math.subtractExact(l, 1L), ChronoUnit.MONTHS);
                long l3 = Math.subtractExact(l2, this.localizedWeekOfMonth(chronoLocalDate));
                int n3 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                chronoLocalDate = chronoLocalDate.plus(Math.addExact(Math.multiplyExact(l3, 7L), (long)n3), ChronoUnit.DAYS);
            } else {
                int n4 = ChronoField.MONTH_OF_YEAR.checkValidIntValue(l);
                chronoLocalDate = chronology.date(n, n4, 1);
                int n5 = this.range.checkValidIntValue(l2, this);
                int n6 = (int)((long)n5 - this.localizedWeekOfMonth(chronoLocalDate));
                int n7 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                chronoLocalDate = chronoLocalDate.plus(n6 * 7 + n7, ChronoUnit.DAYS);
                if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.getLong(ChronoField.MONTH_OF_YEAR) != l) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different month");
                }
            }
            map.remove(this);
            map.remove(ChronoField.YEAR);
            map.remove(ChronoField.MONTH_OF_YEAR);
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        private ChronoLocalDate resolveWoY(Map<TemporalField, Long> map, Chronology chronology, int n, long l, int n2, ResolverStyle resolverStyle) {
            ChronoLocalDate chronoLocalDate = chronology.date(n, 1, 1);
            if (resolverStyle == ResolverStyle.LENIENT) {
                long l2 = Math.subtractExact(l, this.localizedWeekOfYear(chronoLocalDate));
                int n3 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                chronoLocalDate = chronoLocalDate.plus(Math.addExact(Math.multiplyExact(l2, 7L), (long)n3), ChronoUnit.DAYS);
            } else {
                int n4 = this.range.checkValidIntValue(l, this);
                int n5 = (int)((long)n4 - this.localizedWeekOfYear(chronoLocalDate));
                int n6 = n2 - this.localizedDayOfWeek(chronoLocalDate);
                chronoLocalDate = chronoLocalDate.plus(n5 * 7 + n6, ChronoUnit.DAYS);
                if (resolverStyle == ResolverStyle.STRICT && chronoLocalDate.getLong(ChronoField.YEAR) != (long)n) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different year");
                }
            }
            map.remove(this);
            map.remove(ChronoField.YEAR);
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        private ChronoLocalDate resolveWBY(Map<TemporalField, Long> map, Chronology chronology, int n, ResolverStyle resolverStyle) {
            ChronoLocalDate chronoLocalDate;
            int n2 = this.weekDef.weekBasedYear.range().checkValidIntValue(map.get(this.weekDef.weekBasedYear), this.weekDef.weekBasedYear);
            if (resolverStyle == ResolverStyle.LENIENT) {
                chronoLocalDate = this.ofWeekBasedYear(chronology, n2, 1, n);
                long l = map.get(this.weekDef.weekOfWeekBasedYear);
                long l2 = Math.subtractExact(l, 1L);
                chronoLocalDate = chronoLocalDate.plus(l2, ChronoUnit.WEEKS);
            } else {
                int n3 = this.weekDef.weekOfWeekBasedYear.range().checkValidIntValue(map.get(this.weekDef.weekOfWeekBasedYear), this.weekDef.weekOfWeekBasedYear);
                chronoLocalDate = this.ofWeekBasedYear(chronology, n2, n3, n);
                if (resolverStyle == ResolverStyle.STRICT && this.localizedWeekBasedYear(chronoLocalDate) != n2) {
                    throw new DateTimeException("Strict mode rejected resolved date as it is in a different week-based-year");
                }
            }
            map.remove(this);
            map.remove(this.weekDef.weekBasedYear);
            map.remove(this.weekDef.weekOfWeekBasedYear);
            map.remove(ChronoField.DAY_OF_WEEK);
            return chronoLocalDate;
        }

        @Override
        public String getDisplayName(Locale locale) {
            Objects.requireNonNull(locale, "locale");
            if (this.rangeUnit == ChronoUnit.YEARS) {
                LocaleResources localeResources = LocaleProviderAdapter.getResourceBundleBased().getLocaleResources(locale);
                ResourceBundle resourceBundle = localeResources.getJavaTimeFormatData();
                return resourceBundle.containsKey("field.week") ? resourceBundle.getString("field.week") : this.name;
            }
            return this.name;
        }

        @Override
        public TemporalUnit getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public TemporalUnit getRangeUnit() {
            return this.rangeUnit;
        }

        @Override
        public boolean isDateBased() {
            return true;
        }

        @Override
        public boolean isTimeBased() {
            return false;
        }

        @Override
        public ValueRange range() {
            return this.range;
        }

        @Override
        public boolean isSupportedBy(TemporalAccessor temporalAccessor) {
            if (temporalAccessor.isSupported(ChronoField.DAY_OF_WEEK)) {
                if (this.rangeUnit == ChronoUnit.WEEKS) {
                    return true;
                }
                if (this.rangeUnit == ChronoUnit.MONTHS) {
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_MONTH);
                }
                if (this.rangeUnit == ChronoUnit.YEARS) {
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
                }
                if (this.rangeUnit == WEEK_BASED_YEARS) {
                    return temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR);
                }
                if (this.rangeUnit == ChronoUnit.FOREVER) {
                    return temporalAccessor.isSupported(ChronoField.YEAR);
                }
            }
            return false;
        }

        @Override
        public ValueRange rangeRefinedBy(TemporalAccessor temporalAccessor) {
            if (this.rangeUnit == ChronoUnit.WEEKS) {
                return this.range;
            }
            if (this.rangeUnit == ChronoUnit.MONTHS) {
                return this.rangeByWeek(temporalAccessor, ChronoField.DAY_OF_MONTH);
            }
            if (this.rangeUnit == ChronoUnit.YEARS) {
                return this.rangeByWeek(temporalAccessor, ChronoField.DAY_OF_YEAR);
            }
            if (this.rangeUnit == WEEK_BASED_YEARS) {
                return this.rangeWeekOfWeekBasedYear(temporalAccessor);
            }
            if (this.rangeUnit == ChronoUnit.FOREVER) {
                return ChronoField.YEAR.range();
            }
            throw new IllegalStateException("unreachable, rangeUnit: " + this.rangeUnit + ", this: " + this);
        }

        private ValueRange rangeByWeek(TemporalAccessor temporalAccessor, TemporalField temporalField) {
            int n = this.localizedDayOfWeek(temporalAccessor);
            int n2 = this.startOfWeekOffset(temporalAccessor.get(temporalField), n);
            ValueRange valueRange = temporalAccessor.range(temporalField);
            return ValueRange.of(this.computeWeek(n2, (int)valueRange.getMinimum()), this.computeWeek(n2, (int)valueRange.getMaximum()));
        }

        private ValueRange rangeWeekOfWeekBasedYear(TemporalAccessor temporalAccessor) {
            if (!temporalAccessor.isSupported(ChronoField.DAY_OF_YEAR)) {
                return WEEK_OF_YEAR_RANGE;
            }
            int n = this.localizedDayOfWeek(temporalAccessor);
            int n2 = temporalAccessor.get(ChronoField.DAY_OF_YEAR);
            int n3 = this.startOfWeekOffset(n2, n);
            int n4 = this.computeWeek(n3, n2);
            if (n4 == 0) {
                ChronoLocalDate chronoLocalDate = Chronology.from(temporalAccessor).date(temporalAccessor);
                chronoLocalDate = chronoLocalDate.minus(n2 + 7, ChronoUnit.DAYS);
                return this.rangeWeekOfWeekBasedYear(chronoLocalDate);
            }
            ValueRange valueRange = temporalAccessor.range(ChronoField.DAY_OF_YEAR);
            int n5 = (int)valueRange.getMaximum();
            int n6 = this.computeWeek(n3, n5 + this.weekDef.getMinimalDaysInFirstWeek());
            if (n4 >= n6) {
                ChronoLocalDate chronoLocalDate = Chronology.from(temporalAccessor).date(temporalAccessor);
                chronoLocalDate = chronoLocalDate.plus(n5 - n2 + 1 + 7, ChronoUnit.DAYS);
                return this.rangeWeekOfWeekBasedYear(chronoLocalDate);
            }
            return ValueRange.of(1L, n6 - 1);
        }

        @Override
        public String toString() {
            return this.name + "[" + this.weekDef.toString() + "]";
        }
    }
}

