/*==============================================================*/
/* Upgrade struktury z wersji 83 do 84                          */
/*==============================================================*/

/* ============================================================ */
/*   Table: ProdOpak - na potrzeby SUP                          */
/* ============================================================ */
create table ProdOpak
(
   ProductId            integer              not null,
   Znaczenie            smallint             not null,
   Kolejnosc            smallint             not null,
   PackageId            integer              not null,
   Opcja1               smallint             null,
   Opcja2               smallint             null,
   Opcja3               smallint             null,
   Przelicznik          decimal(15,4)        null,
   MinIlosc             decimal(15,4)        null,
   MaxIlosc             decimal(15,4)        null,
   constraint PK_ProdOpak  primary key  (ProductId, Znaczenie, Kolejnosc)
)
go

/* ============================================================ */
/*   Table: FrakcjaDRS - na potrzeby DRS                        */
/* ============================================================ */
create table FrakcjaDRS (
   FrakId               integer              PRIMARY KEY AUTOINCREMENT,
   Nazwa                text(255)            not null,
   Kod                  text(40)             not null,
   Grupa                text(120)            not null,
   Aktywny              smallint             not null,
   CentrFrakId          integer              null,
   CenaZak              decimal(15,4)        null,
   CenaDet              decimal(15,4)        null,
   ExtOperator          text(40)             null,
   ExtId                text(40)             null,
   ExtAktywny           smallint             null,
   ExternalId           text(20)             null,
   Creation             datetime             not null,
   LastUpdate           datetime             not null
)
go

/* ============================================================ */
/*   Table: PosOpakDRS - na potrzeby DRS                        */
/* ============================================================ */
create table PosOpakDRS
(
   PosOpakId            integer              PRIMARY KEY AUTOINCREMENT,
   Nazwa                text(255)            not null,
   EAN                  text(120)            not null,
   Aktywny              smallint             not null,
   CenaKaucji           decimal(15,4)        null,
   ProductId            integer              null,
   ExtOperator          text(40)             null,
   ExtOpakId            text(120)            null,
   ExtFrakId            text(40)             null,
   ExternalId           text(20)             null,
   Creation             datetime             not null,
   LastUpdate           datetime             not null
)
go

/* ============================================================ */
/*   Table: PosDaneOpakDRS - na potrzeby DRS                    */
/* ============================================================ */
create table PosDaneOpakDRS
(
   PosOpakId            integer              not null,
   Znaczenie            smallint             not null,
   Kolejnosc            smallint             not null,
   Wartosc              text(255)            not null,
   constraint PK_PosDaneOpakDRS  primary key  (PosOpakId, Znaczenie, Kolejnosc)
)
go

/* ============================================================ */
/*   Table: PosKuponDRS - na potrzeby DRS                       */
/* ============================================================ */
create table PosKuponDRS
(
   PosKuponId           integer              PRIMARY KEY AUTOINCREMENT,
   ExtOperator          text(40)             null,
   KodKuponu            text(120)            not null,
   Status               smallint             not null,
   PrzydzialKiedy       datetime             null,
   PrzydzialPosId       integer              null,
   EmisjaKiedy          datetime             null,
   EmisjaPosId          integer              null,
   SpalenieKiedy        datetime             null,
   SpaleniePosId        integer              null,
   Creation             datetime             not null,
   LastUpdate           datetime             not null
)
go

/* Update numeru struktury */
UPDATE StructureVersion SET Version = 84
GO